/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;

public class Expression
extends LinkedList<Constraint>
implements Constraint {
    private static final long serialVersionUID = 1L;
    private final boolean complement;
    private final LogicalOperator operator;

    public Expression(LogicalOperator operator) {
        this(operator, false);
    }

    public Expression(LogicalOperator operator, boolean complement) {
        this.operator = operator;
        this.complement = complement;
    }

    @Override
    public String getOperator() {
        return this.operator.name();
    }

    @Override
    public boolean complies(Object value) {
        Boolean result = null;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            boolean complies = constraint.complies(value);
            if (complies) {
                if (!this.operator.equals((Object)LogicalOperator.OR)) continue;
                result = new Boolean(true);
                break;
            }
            if (!this.operator.equals((Object)LogicalOperator.AND)) continue;
            result = new Boolean(false);
            break;
        }
        if (result == null) {
            result = new Boolean(!this.operator.equals((Object)LogicalOperator.OR));
        }
        return result ^ this.complement;
    }

    @Override
    public Constraint getComplement() {
        Expression complement = new Expression(this.operator.equals((Object)LogicalOperator.AND) ? LogicalOperator.OR : LogicalOperator.AND);
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            complement.add(constraint.getComplement());
        }
        return complement;
    }

    @Override
    public String getJSON() {
        int index = 0;
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        builder.append('\"');
        builder.append(this.operator.name());
        builder.append('\"');
        builder.append(',');
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            builder.append(index > 0 ? Character.valueOf(',') : "");
            builder.append(((Constraint)iterator.next()).getJSON());
            ++index;
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean isComplement() {
        return this.complement;
    }

    static enum LogicalOperator {
        AND,
        OR;

    }
}

