/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.streams;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.aries.rsa.provider.fastbin.streams.Chunk;
import org.apache.aries.rsa.provider.fastbin.streams.StreamProvider;

public class StreamProviderImpl
implements StreamProvider {
    private ConcurrentHashMap<Integer, Closeable> streams = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, AtomicInteger> chunks = new ConcurrentHashMap();
    private AtomicInteger counter = new AtomicInteger(0);
    protected static final int CHUNK_SIZE = 65536;
    private static final byte[] EMPTY = new byte[0];
    ThreadLocal<byte[]> buffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };

    @Override
    public int registerStream(InputStream in) {
        int streamID = this.counter.incrementAndGet();
        this.streams.put(streamID, in);
        this.chunks.put(streamID, new AtomicInteger(-1));
        return streamID;
    }

    @Override
    public int registerStream(OutputStream out) {
        int streamID = this.counter.incrementAndGet();
        this.streams.put(streamID, out);
        this.chunks.put(streamID, new AtomicInteger(-1));
        return streamID;
    }

    @Override
    public void close(int streamID) throws IOException {
        Closeable stream = this.streams.remove(streamID);
        this.chunks.remove(streamID);
        if (stream != null) {
            stream.close();
        }
    }

    @Override
    public Chunk read(int streamID) throws IOException {
        InputStream inputStream = (InputStream)this.getStream(streamID);
        AtomicInteger chunkNumber = this.chunks.get(streamID);
        byte[] result = this.buffer.get();
        int read = inputStream.read(result);
        if (read < 0) {
            this.close(streamID);
            return new Chunk(EMPTY, chunkNumber.incrementAndGet(), true);
        }
        if (read != result.length) {
            byte[] tmp = new byte[read];
            System.arraycopy(result, 0, tmp, 0, read);
            result = tmp;
        }
        return new Chunk(result, chunkNumber.incrementAndGet());
    }

    @Override
    public void write(int streamID, Chunk chunk) throws IOException {
        OutputStream out = (OutputStream)this.getStream(streamID);
        int nextChunkNumber = this.chunks.get(streamID).incrementAndGet();
        if (chunk.getChunkNumber() != nextChunkNumber) {
            throw new IOException("Stream corrupted. Received Chunk " + chunk.getChunkNumber() + " but expected " + nextChunkNumber);
        }
        out.write(chunk.getData());
    }

    private <T extends Closeable> T getStream(int id) throws IOException {
        Closeable closeable = this.streams.get(id);
        if (closeable == null) {
            throw new IOException("No Stream with id " + id + "available");
        }
        try {
            Closeable result = closeable;
            return (T)result;
        }
        catch (ClassCastException e) {
            throw new IOException("No Stream with id " + id + "available");
        }
    }
}

