/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.aries.rsa.provider.fastbin.io.ProtocolCodec;
import org.apache.aries.rsa.provider.fastbin.io.Service;
import org.apache.aries.rsa.provider.fastbin.io.Transport;
import org.apache.aries.rsa.provider.fastbin.io.TransportListener;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportPool
implements Service {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TransportPool.class);
    public static final int DEFAULT_POOL_SIZE = 2;
    public static final long DEFAULT_EVICTION_DELAY = TimeUnit.MINUTES.toMillis(5L);
    protected final String uri;
    protected final DispatchQueue queue;
    protected final LinkedList<Pair> pending = new LinkedList();
    protected final Map<Transport, TransportState> transports = new HashMap<Transport, TransportState>();
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected int poolSize;
    protected long evictionDelay;

    public TransportPool(String uri, DispatchQueue queue) {
        this(uri, queue, 2, DEFAULT_EVICTION_DELAY);
    }

    public TransportPool(String uri, DispatchQueue queue, int poolSize, long evictionDelay) {
        this.uri = uri;
        this.queue = queue;
        this.poolSize = poolSize;
        this.evictionDelay = evictionDelay;
    }

    protected abstract Transport createTransport(String var1) throws Exception;

    protected abstract ProtocolCodec createCodec();

    protected abstract void onCommand(Object var1);

    protected abstract void onFailure(Object var1, Throwable var2);

    protected void onDone(Object id) {
        for (TransportState state : this.transports.values()) {
            if (!state.inflight.remove(id)) continue;
            break;
        }
    }

    public void offer(final Object data, final Object id) {
        if (!this.running.get()) {
            throw new IllegalStateException("Transport pool stopped");
        }
        this.queue.execute(new Runnable(){

            @Override
            public void run() {
                Transport transport = TransportPool.this.getIdleTransport();
                if (transport != null) {
                    TransportPool.this.doOffer(transport, data, id);
                    if (transport.full()) {
                        TransportPool.this.transports.get((Object)transport).time = 0L;
                    }
                } else {
                    TransportPool.this.pending.add(new Pair(data, id));
                }
            }
        });
    }

    protected boolean doOffer(Transport transport, Object command, Object id) {
        this.transports.get((Object)transport).inflight.add(id);
        return transport.offer(command);
    }

    protected Transport getIdleTransport() {
        for (Map.Entry<Transport, TransportState> entry : this.transports.entrySet()) {
            if (entry.getValue().time <= 0L) continue;
            return entry.getKey();
        }
        if (this.transports.size() < this.poolSize) {
            try {
                this.startNewTransport();
            }
            catch (Exception e) {
                LOGGER.info("Unable to start new transport", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void start() throws Exception {
        this.start(null);
    }

    @Override
    public void start(Runnable onComplete) throws Exception {
        this.running.set(true);
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Runnable onComplete) {
        if (this.running.compareAndSet(true, false)) {
            this.queue.execute(new Runnable(){

                @Override
                public void run() {
                    final AtomicInteger latch = new AtomicInteger(TransportPool.this.transports.size());
                    Runnable countDown = new Runnable(){

                        @Override
                        public void run() {
                            if (latch.decrementAndGet() == 0) {
                                while (!TransportPool.this.pending.isEmpty()) {
                                    Pair p = TransportPool.this.pending.removeFirst();
                                    TransportPool.this.onFailure(p.id, new IOException("Transport stopped"));
                                }
                                onComplete.run();
                            }
                        }
                    };
                    while (!TransportPool.this.transports.isEmpty()) {
                        Transport transport = TransportPool.this.transports.keySet().iterator().next();
                        TransportState state = TransportPool.this.transports.remove(transport);
                        if (state != null) {
                            for (Object id : state.inflight) {
                                TransportPool.this.onFailure(id, new IOException("Transport stopped"));
                            }
                        }
                        transport.stop(countDown);
                    }
                }
            });
        } else {
            onComplete.run();
        }
    }

    protected void startNewTransport() throws Exception {
        LOGGER.debug("Creating new transport for: {}", (Object)this.uri);
        Transport transport = this.createTransport(this.uri);
        transport.setDispatchQueue(this.queue);
        transport.setProtocolCodec(this.createCodec());
        transport.setTransportListener(new Listener());
        this.transports.put(transport, new TransportState());
        transport.start();
    }

    protected class Listener
    implements TransportListener {
        protected Listener() {
        }

        @Override
        public void onTransportCommand(Transport transport, Object command) {
            TransportPool.this.onCommand(command);
        }

        @Override
        public void onRefill(final Transport transport) {
            while (TransportPool.this.pending.size() > 0 && !transport.full()) {
                Pair pair = TransportPool.this.pending.removeFirst();
                boolean accepted = TransportPool.this.doOffer(transport, pair.command, pair.id);
                assert (accepted) : "Should have been accepted since the transport was not full";
            }
            if (transport.full()) {
                TransportPool.this.transports.get((Object)transport).time = 0L;
            } else {
                long time;
                TransportPool.this.transports.get((Object)transport).time = time = System.currentTimeMillis();
                if (TransportPool.this.evictionDelay > 0L) {
                    TransportPool.this.queue.executeAfter(TransportPool.this.evictionDelay, TimeUnit.MILLISECONDS, new Runnable(){

                        @Override
                        public void run() {
                            TransportState state = TransportPool.this.transports.get(transport);
                            if (state != null && state.time == time) {
                                TransportPool.this.transports.remove(transport);
                                transport.stop();
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void onTransportFailure(Transport transport, IOException error) {
            if (!transport.isDisposed()) {
                LOGGER.info("Transport failure", (Throwable)error);
                TransportState state = TransportPool.this.transports.remove(transport);
                if (state != null) {
                    for (Object id : state.inflight) {
                        TransportPool.this.onFailure(id, error);
                    }
                }
                transport.stop();
                if (TransportPool.this.transports.isEmpty()) {
                    while (!TransportPool.this.pending.isEmpty()) {
                        Pair p = TransportPool.this.pending.removeFirst();
                        TransportPool.this.onFailure(p.id, error);
                    }
                }
            }
        }

        @Override
        public void onTransportConnected(Transport transport) {
            transport.resumeRead();
            this.onRefill(transport);
        }

        @Override
        public void onTransportDisconnected(Transport transport) {
            this.onTransportFailure(transport, new IOException("Transport disconnected"));
        }
    }

    protected static class TransportState {
        long time = 0L;
        final Set<Object> inflight = new HashSet<Object>();
    }

    protected static class Pair {
        Object command;
        Object id;

        public Pair(Object command, Object id) {
            this.command = command;
            this.id = id;
        }
    }
}

