/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.common.constraint;

import java.lang.reflect.Array;
import org.eclipse.sensinact.gateway.common.constraint.Absolute;
import org.eclipse.sensinact.gateway.common.constraint.Changed;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.constraint.ConstraintFactory;
import org.eclipse.sensinact.gateway.common.constraint.Contains;
import org.eclipse.sensinact.gateway.common.constraint.Delta;
import org.eclipse.sensinact.gateway.common.constraint.Different;
import org.eclipse.sensinact.gateway.common.constraint.Exists;
import org.eclipse.sensinact.gateway.common.constraint.Fixed;
import org.eclipse.sensinact.gateway.common.constraint.InvalidConstraintDefinitionException;
import org.eclipse.sensinact.gateway.common.constraint.Length;
import org.eclipse.sensinact.gateway.common.constraint.MaxExclusive;
import org.eclipse.sensinact.gateway.common.constraint.MaxInclusive;
import org.eclipse.sensinact.gateway.common.constraint.MaxLength;
import org.eclipse.sensinact.gateway.common.constraint.MinExclusive;
import org.eclipse.sensinact.gateway.common.constraint.MinInclusive;
import org.eclipse.sensinact.gateway.common.constraint.MinLength;
import org.eclipse.sensinact.gateway.common.constraint.Pattern;
import org.eclipse.sensinact.gateway.common.constraint.True;
import org.eclipse.sensinact.gateway.util.CastUtils;

public class DefaultConstraintFactory
implements ConstraintFactory {
    @Override
    public Constraint newInstance(String constraint, Class<?> referenceType, Object reference, boolean complement) throws InvalidConstraintDefinitionException {
        Type type = null;
        type = DefaultConstraintFactory.valueOf(constraint.toUpperCase());
        if (type == null && (type = Type.fromOperator(constraint)) == null) {
            throw new InvalidConstraintDefinitionException("Unknown constraint :" + constraint);
        }
        Constraint instance = null;
        switch (type) {
            case ABSOLUTE: {
                if (!reference.getClass().isArray() || Array.getLength(reference) != 2) {
                    throw new InvalidConstraintDefinitionException("Invalid constraint definition :  " + "array of Numbers expected");
                }
                instance = new Absolute(Array.get(reference, 0), Array.get(reference, 1), complement);
                break;
            }
            case CHANGED: {
                instance = new Changed(complement);
                break;
            }
            case DELTA: {
                if (!reference.getClass().isArray() || Array.getLength(reference) != 2) {
                    throw new InvalidConstraintDefinitionException("Invalid constraint definition :  " + "array of Numbers expected");
                }
                instance = new Delta(Array.get(reference, 0), Array.get(reference, 1), complement);
                break;
            }
            case DIFFERENT: {
                instance = new Different(referenceType, reference, complement);
                break;
            }
            case EXISTS: {
                instance = new Exists(complement);
                break;
            }
            case FIXED: {
                instance = new Fixed(referenceType, reference, complement);
                break;
            }
            case MAXEXCLUSIVE: {
                instance = new MaxExclusive(referenceType, reference, complement);
                break;
            }
            case MAXINCLUSIVE: {
                instance = new MaxInclusive(referenceType, reference, complement);
                break;
            }
            case MINEXCLUSIVE: {
                instance = new MinExclusive(referenceType, reference, complement);
                break;
            }
            case MININCLUSIVE: {
                instance = new MinInclusive(referenceType, reference, complement);
                break;
            }
            case ENUMERATION: {
                instance = new Contains(referenceType, reference, complement);
                break;
            }
            case LENGTH: {
                referenceType = Integer.TYPE;
                instance = new Length((Integer)CastUtils.cast(Integer.TYPE, (Object)reference), complement);
                break;
            }
            case MAXLENGTH: {
                referenceType = Integer.TYPE;
                instance = new MaxLength((Integer)CastUtils.cast(Integer.TYPE, (Object)reference), complement);
                break;
            }
            case MINLENGTH: {
                referenceType = Integer.TYPE;
                instance = new MinLength((Integer)CastUtils.cast(Integer.TYPE, (Object)reference), complement);
                break;
            }
            case PATTERN: {
                referenceType = String.class;
                instance = new Pattern(String.valueOf(reference), complement);
                break;
            }
            case TRUE: {
                instance = new True(complement);
                break;
            }
            default: {
                return null;
            }
        }
        return instance;
    }

    @Override
    public boolean handle(String constraint) {
        return DefaultConstraintFactory.valueOf(constraint.toUpperCase()) != null || Type.fromOperator(constraint) != null;
    }

    private static final Type valueOf(String constraint) {
        Type type = null;
        try {
            type = Type.valueOf(constraint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return type;
    }

    public static enum Type {
        ABSOLUTE("abs"),
        CHANGED("changed"),
        DELTA("diff"),
        DIFFERENT("!="),
        ENUMERATION("in"),
        EXISTS("OPERATOR"),
        FIXED("="),
        LENGTH("len"),
        MAXEXCLUSIVE("<"),
        MAXINCLUSIVE("<="),
        MINEXCLUSIVE(">"),
        MININCLUSIVE(">="),
        MAXLENGTH("-"),
        MINLENGTH("+"),
        PATTERN("regex"),
        TRUE("OPERATOR");

        private final String operator;

        public static Type fromOperator(String operator) {
            Type[] values = Type.values();
            int length = values.length;
            for (int index = 0; index < length; ++index) {
                if (values[index].getOperator().intern() != operator.intern()) continue;
                return values[index];
            }
            return null;
        }

        private Type(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }
    }
}

