/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.commands.gogo.internal.shell;

import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ShellOutput {
    public void output(JSONObject object, int offset) {
        int length;
        String[] names = JSONObject.getNames((JSONObject)object);
        int n = length = names == null ? 0 : names.length;
        for (int index = 0; index < length; ++index) {
            String name = names[index];
            if (offset == 0 && (name.equals("type") || name.equals("statusCode"))) continue;
            Object value = object.get(name);
            if (CastUtils.isPrimitive(value.getClass())) {
                StringBuilder builder = new StringBuilder();
                builder.append(name);
                builder.append(" : ");
                builder.append(value);
                this.output(builder.toString(), offset);
                continue;
            }
            if (value.getClass() == JSONObject.class) {
                this.outputUnderlined(name, offset + 4);
                this.output((JSONObject)value, offset + 4);
                continue;
            }
            if (value.getClass() != JSONArray.class) continue;
            this.outputUnderlined(name, offset + 4);
            this.output((JSONArray)value, offset + 4);
        }
    }

    public void output(JSONArray object, int offset) {
        int length;
        int n = length = object == null ? 0 : object.length();
        for (int index = 0; index < length; ++index) {
            Object value = object.get(index);
            if (CastUtils.isPrimitive(value.getClass())) {
                this.output(String.valueOf(value), offset);
                continue;
            }
            if (value.getClass() == JSONObject.class) {
                this.output((JSONObject)value, offset + 4);
                continue;
            }
            if (value.getClass() != JSONArray.class) continue;
            this.output((JSONArray)value, offset + 4);
        }
    }

    public void output(String s, int offset) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < offset; ++index) {
            builder.append(' ');
        }
        builder.append(s);
        System.out.println(builder.toString());
    }

    public void outputUnderlined(String s, int offset) {
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index < s.length(); ++index) {
            builder.append('-');
        }
        this.output(s, offset);
        this.output(builder.toString(), offset);
    }

    public void outputQuoted(String s, int offset) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        builder.append(s);
        builder.append('\"');
        this.output(builder.toString(), offset);
    }

    public void outputError(int statusCode, String s) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error [");
        builder.append(statusCode);
        builder.append("] :");
        builder.append('\"');
        builder.append(s);
        builder.append('\"');
        this.output(builder.toString(), 0);
    }
}

