/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.kodi.internal;

import org.json.JSONArray;
import org.json.JSONObject;

public enum KodiApi {
    GETADDONS("Addons.GetAddons"){

        @Override
        public Object getData(Object result) throws Exception {
            return ((JSONObject)result).getJSONArray("addons");
        }

        @Override
        public JSONObject getContent(Object[] parameters) throws Exception {
            return null;
        }
    }
    ,
    GETSOURCES("Files.GetSources"){

        @Override
        public Object getData(Object result) throws Exception {
            JSONArray files = ((JSONObject)result).getJSONArray("files");
            JSONArray movies = new JSONArray();
            for (int i = 0; i < files.length(); ++i) {
                movies.put((Object)files.getJSONObject(i).getString("file"));
            }
            return movies;
        }

        @Override
        public JSONObject getContent(Object[] parameters) throws Exception {
            return new JSONObject().put("media", (Object)"video");
        }
    }
    ,
    GETDIRECTORY("Files.GetDirectory"){

        @Override
        public Object getData(Object result) throws Exception {
            JSONArray sources = ((JSONObject)result).getJSONArray("sources");
            return sources.getJSONObject(0).getString("file");
        }

        @Override
        public JSONObject getContent(Object[] parameters) throws Exception {
            return new JSONObject().put("media", (Object)"video").put("directory", parameters[0]);
        }
    }
    ,
    GETVOLUME("Application.GetProperties"){

        @Override
        public Object getData(Object result) throws Exception {
            return ((JSONObject)result).getInt("volume");
        }

        @Override
        public JSONObject getContent(Object[] parameters) throws Exception {
            return new JSONObject().put("properties", (Object)new JSONArray().put((Object)"volume"));
        }
    }
    ,
    PLAYEROPEN("Player.Open"){

        @Override
        public JSONObject getContent(Object[] parameters) throws Exception {
            return new JSONObject().put("item", (Object)new JSONObject().put("file", parameters[0]));
        }
    }
    ,
    OTHER(null);

    private final String name;

    private KodiApi(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object getData(Object result) throws Exception {
        return null;
    }

    public JSONObject getContent(Object[] parameters) throws Exception {
        return null;
    }

    public static final KodiApi fromName(String name) {
        int length;
        if (name == null) {
            return null;
        }
        KodiApi[] apis = KodiApi.values();
        int n = length = apis == null ? 0 : apis.length;
        for (int index = 0; index < length; ++index) {
            if (!name.equalsIgnoreCase(apis[index].getName())) continue;
            return apis[index];
        }
        return null;
    }
}

