/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SignatureUtil {
    private static final Logger LOGGER = Logger.getLogger(SignatureUtil.class.getCanonicalName());
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";
    private static final String CHARSET = "utf-8";
    private static final String ENCRYPTION_ALGORITHM = "RSA";
    private static final String HASH_ENCRYPTION_ALGORITHM = "SHA1withRSA";

    private SignatureUtil() {
    }

    public static boolean checkSign(String message, String sign, String keyPath) {
        boolean ret = false;
        try {
            ret = SignatureUtil.verify(message, sign, SignatureUtil.getKey(keyPath));
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicKey getKey(String keyPath) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(ENCRYPTION_ALGORITHM);
        try (BufferedReader reader = new BufferedReader(new FileReader(keyPath));){
            String line = reader.readLine();
            int index = -1;
            String type = null;
            byte[] content = null;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (line != null && line.startsWith(BEGIN)) {
                line = line.substring(BEGIN.length());
                index = line.indexOf(45);
                type = line.substring(0, index);
                if (index > 0) {
                    String endMarker = END + type;
                    StringBuffer buf = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        if (line.indexOf(":") >= 0) {
                            index = line.indexOf(58);
                            String hdr = line.substring(0, index);
                            String value = line.substring(index + 1).trim();
                            headers.put(hdr, value);
                            continue;
                        }
                        if (line.indexOf(endMarker) != -1) break;
                        buf.append(line.trim());
                    }
                    if (line == null) {
                        throw new IOException(endMarker + " not found");
                    }
                    content = Base64.getDecoder().decode(buf.toString());
                }
                PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(content));
                return publicKey;
            }
        }
        return null;
    }

    private static boolean verify(String message, String sign, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException {
        Signature sig = Signature.getInstance(HASH_ENCRYPTION_ALGORITHM);
        sig.initVerify(publicKey);
        sig.update(message.getBytes(CHARSET));
        byte[] bytes = Base64.getDecoder().decode(URLDecoder.decode(sign, CHARSET));
        return sig.verify(bytes);
    }
}

