/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.application;

import org.eclipse.sensinact.gateway.app.api.exception.ResourceNotFoundException;
import org.eclipse.sensinact.gateway.app.api.lifecycle.ApplicationStatus;
import org.eclipse.sensinact.gateway.app.manager.application.Application;
import org.eclipse.sensinact.gateway.app.manager.application.ApplicationService;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.message.SnaErrorMessage;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.json.JSONObject;

class AppStopExecutor
implements AccessMethodExecutor {
    private final ApplicationService service;

    AppStopExecutor(ApplicationService service) {
        this.service = service;
    }

    public Void execute(AccessMethodResponseBuilder jsonObjects) throws Exception {
        ApplicationStatus status = this.getApplicationState(this.service.getResource("status"));
        if (ApplicationStatus.ACTIVE.equals((Object)status)) {
            Application application = this.service.getApplication();
            SnaErrorMessage message = application.stop();
            if (message.getType() == SnaErrorMessage.Error.NO_ERROR) {
                jsonObjects.push((Object)new JSONObject().put("message", (Object)("Application " + this.service.getName() + " stopped")));
            } else {
                jsonObjects.registerException((Exception)new ResourceNotFoundException("Unable to stop the application: " + message.getJSON()));
            }
        } else {
            jsonObjects.push((Object)new JSONObject().put("message", (Object)("Unable to stop the application " + this.service.getName())));
        }
        return null;
    }

    private ApplicationStatus getApplicationState(ResourceImpl state) {
        Attribute stateAttribute;
        if (state != null && (stateAttribute = state.getAttribute("value")) != null) {
            return (ApplicationStatus)((Object)stateAttribute.getValue());
        }
        return null;
    }
}

