/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.manager.json;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.sensinact.gateway.app.manager.json.AppCondition;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.JSONable;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppEvent
implements JSONable {
    protected final String uri;
    protected final EventType type;
    protected final Set<AppCondition> conditions;

    public AppEvent(Mediator mediator, JSONObject json) {
        this.uri = json.getString("value");
        this.type = "resource".equals(json.getString("type")) ? EventType.RESOURCE : EventType.VARIABLE;
        this.conditions = new HashSet<AppCondition>();
        if (json.has("conditions")) {
            JSONArray conditionsArray = json.getJSONArray("conditions");
            for (int i = 0; i < conditionsArray.length(); ++i) {
                this.conditions.add(new AppCondition(mediator, conditionsArray.getJSONObject(i)));
            }
        }
    }

    public String getUri() {
        return this.uri;
    }

    public EventType getType() {
        return this.type;
    }

    public Set<AppCondition> getConditions() {
        return this.conditions;
    }

    public String getJSON() {
        JSONObject json = new JSONObject().put("value", (Object)this.uri).put("type", (Object)this.type);
        if (!this.conditions.isEmpty()) {
            JSONArray conditionsArray = new JSONArray();
            for (AppCondition condition : this.conditions) {
                conditionsArray.put((Object)condition.getJSON());
            }
            json.put("conditions", (Object)conditionsArray);
        }
        return json.toString();
    }

    public static enum EventType {
        RESOURCE,
        VARIABLE;

    }
}

