/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundEndpoint;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WebSocketConnectionFactory;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WsRestAccess;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.ws.WsRestAccessRequest;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxIdleTime=0, maxTextMessageSize=65536)
public class WebSocketConnection {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketConnection.class);
    protected static final String LOGIN_PATH = "sensinact-login";
    protected static final String LOGIN_URI = "/sensinact-login";
    protected Session session;
    protected NorthboundMediator mediator;
    protected WebSocketConnectionFactory pool;
    protected NorthboundEndpoint endpoint;
    private boolean partial;
    private byte[] payload;

    protected WebSocketConnection(WebSocketConnectionFactory pool, NorthboundEndpoint endpoint, NorthboundMediator mediator) {
        this.endpoint = endpoint;
        this.mediator = mediator;
        this.pool = pool;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.pool.deleteSocketEndpoint(this);
    }

    protected void close() {
        if (this.session == null) {
            return;
        }
        if (this.session.isOpen()) {
            try {
                this.session.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        this.session = null;
    }

    NorthboundEndpoint getEndpoint() {
        return this.endpoint;
    }

    @OnWebSocketMessage
    public void onMessage(String message) {
        if (this.partial) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(message);
            WsRestAccessRequest wrapper = new WsRestAccessRequest(this.mediator, this, jsonObject);
            WsRestAccess restAccess = new WsRestAccess(wrapper, this);
            restAccess.proceed();
        }
        catch (IOException | JSONException e) {
            LOG.error(e.getMessage(), e);
            try {
                this.send(new JSONObject().put("statusCode", 400).put("message", (Object)"Bad request").toString());
            }
            catch (Exception e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
        }
        catch (InvalidCredentialException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                this.send(new JSONObject().put("statusCode", 403).put("message", (Object)e.getMessage()).toString());
            }
            catch (Exception e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                this.send(new JSONObject().put("statusCode", 500).put("message", (Object)"Exception - Internal server error").toString());
            }
            catch (Exception e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
        }
    }

    @OnWebSocketFrame
    public void onFrame(Frame frame) {
        switch (frame.getOpCode()) {
            case 9: {
                this.partial = true;
                try {
                    this.session.getRemote().sendPong(ByteBuffer.allocate(0));
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
            case 10: {
                this.partial = true;
                break;
            }
            case 0: {
                this.partial = true;
                byte[] bytes = new byte[frame.getPayloadLength()];
                frame.getPayload().get(bytes);
                int length = this.payload == null ? 0 : this.payload.length;
                byte[] tmpArray = new byte[length + bytes.length];
                if (bytes.length > 0) {
                    System.arraycopy(bytes, 0, tmpArray, length, bytes.length);
                }
                if (length > 0) {
                    System.arraycopy(this.payload, 0, tmpArray, 0, length);
                }
                this.payload = tmpArray;
                tmpArray = null;
                if (!frame.isFin()) break;
                this.partial = false;
                this.onMessage(new String(this.payload));
                this.partial = true;
                this.payload = null;
                break;
            }
            default: {
                if (!frame.isFin()) break;
                this.partial = false;
            }
        }
    }

    @OnWebSocketError
    public void handleError(Throwable error) {
        error.printStackTrace();
    }

    protected void send(String message) throws Exception {
        if (this.session == null) {
            return;
        }
        try {
            if (message.length() > 65536) {
                int offset = 32000;
                String piece = null;
                for (int index = 0; index < message.length(); index += offset) {
                    if (index + offset > message.length()) {
                        offset = message.length() - index;
                    }
                    piece = message.substring(index, index + offset);
                    this.session.getRemote().sendPartialString(piece, index + offset == message.length());
                }
            } else {
                Future future = this.session.getRemote().sendStringByFuture(message);
                future.get(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LOG.error("Session " + this.session.getLocalAddress() + "seems to be invalid, removing from the pool.", (Throwable)e);
            this.pool.deleteSocketEndpoint(this);
            throw e;
        }
    }

    protected void send(byte[] message) throws Exception {
        if (this.session == null) {
            return;
        }
        try {
            if (message.length > 65536) {
                int offset = 32000;
                for (int index = 0; index < message.length; index += offset) {
                    if (index + offset > message.length) {
                        offset = message.length - index;
                    }
                    ByteBuffer buffer = ByteBuffer.wrap(message, index, offset);
                    this.session.getRemote().sendPartialBytes(buffer, index + offset == message.length);
                }
            } else {
                Future future = this.session.getRemote().sendBytesByFuture(ByteBuffer.wrap(message));
                future.get(1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LOG.error("Session " + this.session.getLocalAddress() + "seems to be invalid, removing from the pool.", (Throwable)e);
            this.pool.deleteSocketEndpoint(this);
            throw e;
        }
    }
}

