/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.device.openhab.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.device.openhab.internal.OpenhabType;
import org.eclipse.sensinact.gateway.device.openhab.sensinact.OpenHabMediator;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.SimplePacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHabPacketReader
extends SimplePacketReader<HttpPacket> {
    static final Logger LOG = LoggerFactory.getLogger(OpenHabPacketReader.class);
    static final MessageFormat TEMPERATURE_FORMAT = new MessageFormat("{0} \u00b0C");
    private static final String OPENHAB_ZWAVE_PROVIDER_ID_PATTERN = "{0}_node{1}";
    private static final String OPENHAB_ZWAVE_DEVICE_ID_PATTERN = "{0}_node{1}_{2}_{3}";
    protected static final MessageFormat OPENHAB_ZWAVE_PROVIDER_ID_FORMAT = new MessageFormat("{0}_node{1}");
    private static final MessageFormat OPENHAB_ZWAVE_DEVICE_ID_FORMAT = new MessageFormat("{0}_node{1}_{2}_{3}");
    private static final String DEFAULT_OPENHAB_SERVICE_ID = "info";
    private static final String DEFAULT_OPENHAB_RESOURCE_ID = "value";
    private List<Processable> processables;
    private Map<String, Set<String>> devices;
    private JSONArray itemsArray = null;
    private JSONObject item = null;
    private int pos = 0;
    private Mediator mediator;

    static String[] parseOpenhabPath(String openhabDeviceId) throws ParseException {
        String[] path = new String[4];
        Object[] parsedOpenhabPath = OPENHAB_ZWAVE_DEVICE_ID_FORMAT.parse(openhabDeviceId);
        for (int i = 0; i < 4; ++i) {
            path[i] = parsedOpenhabPath[i].toString();
        }
        return path;
    }

    public OpenHabPacketReader(Mediator mediator) {
        this.mediator = mediator;
    }

    public void load(HttpPacket packet) throws InvalidPacketException {
        this.item = null;
        this.itemsArray = null;
        this.processables = new ArrayList<Processable>();
        this.devices = new HashMap<String, Set<String>>();
        byte[] content = packet.getBytes();
        if (content != null && content.length > 0) {
            String sb = new String(content);
            try {
                this.itemsArray = new JSONArray(sb);
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws InvalidPacketException {
        if (this.processables != null && !this.processables.isEmpty()) {
            this.processables.remove(0).process();
            return;
        }
        if (this.itemsArray == null || this.pos == this.itemsArray.length()) {
            if (this.devices != null && this.devices.size() > 0) {
                this.devices.entrySet().stream().forEach(e -> {
                    String openHabId = (String)e.getKey();
                    Set devices = (Set)e.getValue();
                    ((OpenHabMediator)this.mediator).updateBroker(openHabId, devices).stream().forEach(s -> this.processables.add(new Processable(Mode.DELETE, new HierarchyDTO((String)s, null, null), null, null)));
                });
                this.devices.clear();
                this.parse();
                return;
            }
            super.configureEOF();
            return;
        }
        try {
            this.item = this.itemsArray.getJSONObject(this.pos);
            String openhaDeviceId = this.item.getString("name");
            String type = this.item.getString("type");
            String link = this.item.getString("link");
            String value = this.item.getString("state");
            try {
                this.parseItem(this.item.getString("name"), type, value);
                try {
                    URL url = new URL(link);
                    String openHabId = "openHab".concat(String.valueOf((url.getHost() + url.getPort()).hashCode()));
                    Set<String> s = this.devices.get(openHabId);
                    if (s == null) {
                        s = new HashSet<String>();
                        this.devices.put(openHabId, s);
                    }
                    s.add(openhaDeviceId);
                }
                catch (MalformedURLException url) {
                    // empty catch block
                }
            }
            catch (Exception e1) {
                try {
                    this.parseThing(this.item);
                }
                catch (Exception e2) {
                    LOG.warn("OpenHab device error", (Throwable)e2);
                }
            }
            finally {
                this.item = null;
                ++this.pos;
            }
            if (!this.processables.isEmpty()) {
                this.parse();
                return;
            }
        }
        catch (JSONException e2) {
            super.configureEOF();
            throw new InvalidPacketException((Throwable)e2);
        }
        super.configureEOF();
    }

    private void parseItem(String openhaDeviceId, String type, String value) throws JSONException {
        HierarchyDTO hierarchy = this.getHierarchy(openhaDeviceId);
        this.processables.add(new Processable(Mode.UPDATE, hierarchy, type, value));
    }

    private void parseThing(JSONObject jo) throws JSONException {
        String uuid = jo.getString("UID");
        JSONObject statusInfo = jo.getJSONObject("statusInfo");
        String label = jo.getString("label");
        String status = statusInfo.getString("status");
        String statusDetail = statusInfo.getString("statusDetail");
        String openhaDeviceId = uuid.replaceAll(":", "_");
        this.processables.add(new Processable(Mode.UPDATE, new HierarchyDTO(openhaDeviceId, "admin", "friendlyName"), null, label));
        this.processables.add(new Processable(Mode.UPDATE, new HierarchyDTO(openhaDeviceId, "status", "connected"), null, status.equals("ONLINE")));
        this.processables.add(new Processable(Mode.UPDATE, new HierarchyDTO(openhaDeviceId, "status", "detail"), null, statusDetail));
    }

    private HierarchyDTO getHierarchy(String openhabDeviceId) {
        try {
            String[] parsedOpenhabPath = OpenHabPacketReader.parseOpenhabPath(openhabDeviceId);
            String providerId = OPENHAB_ZWAVE_PROVIDER_ID_FORMAT.format(parsedOpenhabPath);
            return new HierarchyDTO(providerId, parsedOpenhabPath[2], parsedOpenhabPath[3]);
        }
        catch (Exception ex) {
            return new HierarchyDTO(openhabDeviceId, DEFAULT_OPENHAB_SERVICE_ID, DEFAULT_OPENHAB_RESOURCE_ID);
        }
    }

    private class Processable {
        public final Mode mode;
        public final HierarchyDTO hierarchyDTO;
        public final String type;
        public final Object value;

        Processable(Mode mode, HierarchyDTO hierarchyDTO, String type, Object value) {
            this.mode = mode;
            this.hierarchyDTO = hierarchyDTO;
            this.type = type;
            this.value = value;
        }

        void process() {
            switch (this.mode) {
                case DELETE: {
                    OpenHabPacketReader.this.setServiceProviderId(this.hierarchyDTO.provider);
                    OpenHabPacketReader.this.isGoodbyeMessage(true);
                    OpenHabPacketReader.this.setTimestamp(System.currentTimeMillis());
                    OpenHabPacketReader.this.configure();
                    break;
                }
                case UPDATE: {
                    Object data = OpenhabType.parseValue(this.type == null ? OpenhabType.Default.name() : this.type, this.value);
                    OpenHabPacketReader.this.setServiceId(this.hierarchyDTO.service);
                    OpenHabPacketReader.this.setResourceId(this.hierarchyDTO.resource);
                    OpenHabPacketReader.this.setTimestamp(System.currentTimeMillis());
                    OpenHabPacketReader.this.setData(data);
                    OpenHabPacketReader.this.configure();
                    break;
                }
            }
        }
    }

    static enum Mode {
        UPDATE,
        DELETE;

    }

    private class HierarchyDTO {
        public final String provider;
        public final String service;
        public final String resource;

        HierarchyDTO(String provider, String service, String resource) {
            this.provider = provider;
            this.service = service;
            this.resource = resource;
        }
    }
}

