/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.Attribute;
import org.eclipse.sensinact.gateway.core.AttributeDescription;
import org.eclipse.sensinact.gateway.core.InvalidResourceException;
import org.eclipse.sensinact.gateway.core.ModelInstance;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedResourceImpl
extends ResourceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedResourceImpl.class);
    protected final ResourceImpl targetedResource;

    public LinkedResourceImpl(ModelInstance<?> modelInstance, ResourceConfig resourceConfig, ResourceImpl targetedResource, ServiceImpl service) throws InvalidResourceException {
        super(modelInstance, resourceConfig, service);
        this.targetedResource = targetedResource;
    }

    @Override
    public void buildAttributes(ResourceConfig resourceConfig) {
        String defaultAttributeName = (String)resourceConfig.getTypeConfig().getConstantValue("ATTRIBUTE_DEFAULT", false);
        super.setDefault(defaultAttributeName);
        try {
            this.elements.add(new Attribute(this.modelInstance.mediator(), this, "name", String.class, UriUtils.getLeaf((String)this.uri), Modifiable.FIXED, true));
        }
        catch (InvalidValueException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Attribute getAttribute(String name) {
        Attribute attribute = null;
        attribute = super.getAttribute(name);
        if (attribute == null) {
            attribute = this.targetedResource.getAttribute(name);
        }
        return attribute;
    }

    @Override
    public AttributeDescription getDescription(String name) {
        AttributeDescription description = null;
        Attribute primitive = this.getAttribute(name);
        description = primitive != null ? (AttributeDescription)primitive.getDescription() : this.targetedResource.getDescription(name);
        return description;
    }

    @Override
    public List<AttributeDescription> getAllDescriptions() {
        List<AttributeDescription> descriptions = super.getAllDescriptions();
        if (this.targetedResource == null) {
            return descriptions;
        }
        List<AttributeDescription> linkedDescriptions = this.targetedResource.getAllDescriptions();
        ArrayList<AttributeDescription> allDescriptions = new ArrayList<AttributeDescription>();
        allDescriptions.addAll(descriptions);
        allDescriptions.addAll(linkedDescriptions);
        return allDescriptions;
    }

    @Override
    public Resource.Type getType() {
        return this.targetedResource.getType();
    }

    @Override
    public void registerLink(String path) {
        LOG.debug("Unable to register a link for a LinkedResourceImpl");
    }
}

