/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.util.Vector;

public enum SubscriptionMode {
    NONE(0),
    ON_CHANGE(1),
    SCHEDULED(2),
    CONDITIONAL(4),
    BUFFERIZED(8),
    TIMED_OUT(16);

    protected final byte mode;

    private SubscriptionMode(byte mode) {
        this.mode = mode;
    }

    public static boolean contains(byte mode, SubscriptionMode subscriptionMode) {
        return (mode & subscriptionMode.mode) == subscriptionMode.mode;
    }

    public static byte valueOf(SubscriptionMode[] modes) {
        int length;
        byte mode = SubscriptionMode.NONE.mode;
        int n = length = modes == null ? 0 : modes.length;
        for (int index = 0; index < length; ++index) {
            mode = (byte)(mode | modes[index].mode);
        }
        return mode;
    }

    public static SubscriptionMode[] valueOf(byte mode) {
        int length;
        SubscriptionMode[] modes = SubscriptionMode.values();
        Vector<SubscriptionMode> contained = new Vector<SubscriptionMode>();
        int n = length = modes == null ? 0 : modes.length;
        for (int index = 0; index < length; ++index) {
            if (!SubscriptionMode.contains(mode, modes[index])) continue;
            contained.add(modes[index]);
        }
        return contained.toArray(new SubscriptionMode[contained.size()]);
    }

    public static String getJSON(SubscriptionMode[] modes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append('\"');
        buffer.append("subscriptionMode");
        buffer.append('\"');
        buffer.append(':');
        buffer.append(SubscriptionMode.valueOf(modes));
        return buffer.toString();
    }
}

