/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.spi;

import io.moquette.spi.ClientSession;
import io.moquette.spi.IMessagesStore;
import io.moquette.spi.MessageGUID;
import io.moquette.spi.impl.subscriptions.Subscription;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public interface ISessionsStore {
    public void initStore();

    public void updateCleanStatus(String var1, boolean var2);

    public void addNewSubscription(Subscription var1);

    public void removeSubscription(String var1, String var2);

    public void wipeSubscriptions(String var1);

    public List<ClientTopicCouple> listAllSubscriptions();

    public Subscription getSubscription(ClientTopicCouple var1);

    public List<Subscription> getSubscriptions();

    public boolean contains(String var1);

    public ClientSession createNewSession(String var1, boolean var2);

    public ClientSession sessionForClient(String var1);

    public void inFlightAck(String var1, int var2);

    public void inFlight(String var1, int var2, MessageGUID var3);

    public int nextPacketID(String var1);

    public BlockingQueue<IMessagesStore.StoredMessage> queue(String var1);

    public void dropQueue(String var1);

    public void moveInFlightToSecondPhaseAckWaiting(String var1, int var2);

    public MessageGUID secondPhaseAcknowledged(String var1, int var2);

    public MessageGUID mapToGuid(String var1, int var2);

    public IMessagesStore.StoredMessage getInflightMessage(String var1, int var2);

    public static class ClientTopicCouple {
        public final String topicFilter;
        public final String clientID;

        public ClientTopicCouple(String clientID, String topicFilter) {
            this.clientID = clientID;
            this.topicFilter = topicFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientTopicCouple that = (ClientTopicCouple)o;
            if (this.topicFilter != null ? !this.topicFilter.equals(that.topicFilter) : that.topicFilter != null) {
                return false;
            }
            return !(this.clientID == null ? that.clientID != null : !this.clientID.equals(that.clientID));
        }

        public int hashCode() {
            int result = this.topicFilter != null ? this.topicFilter.hashCode() : 0;
            result = 31 * result + (this.clientID != null ? this.clientID.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ClientTopicCouple{topicFilter='" + this.topicFilter + '\'' + ", clientID='" + this.clientID + '\'' + '}';
        }
    }
}

