/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.user.openid;

import java.util.Objects;
import org.eclipse.sensinact.gateway.core.security.user.openid.JsonWebToken;
import org.eclipse.sensinact.gateway.core.security.user.openid.OpenIdUserKeyBuilderConfig;

public final class OpenIdUser {
    public static final String USER_PUBLIC_KEY_CLAIM = "snaKey";
    private final JsonWebToken idToken;
    private final JsonWebToken accessToken;
    private boolean valid;

    public OpenIdUser(OpenIdUserKeyBuilderConfig userKeyBuilderConfig, String decodedId, JsonWebToken access) {
        String authzParty;
        Objects.requireNonNull(decodedId, "A user must have an id");
        Objects.requireNonNull(access, "A user must have an access token");
        this.idToken = new JsonWebToken(decodedId);
        this.accessToken = access;
        boolean result = false;
        Object azp = access.claim("azp");
        if (azp != null && !(result = (authzParty = String.valueOf(azp)).contains(userKeyBuilderConfig.getClientId()))) {
            System.out.println("Bad client Id " + authzParty + " / " + userKeyBuilderConfig.getClientId());
        }
        this.valid = result && this.idToken.isValid() && this.accessToken.isValid();
    }

    public String getSensiNactPublicKey() {
        Object publicKey = this.idToken.claim(USER_PUBLIC_KEY_CLAIM);
        if (publicKey == null) {
            return null;
        }
        return String.valueOf(publicKey);
    }

    public boolean isValid() {
        return this.valid;
    }
}

