/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.signature.exception.BundleValidationException;
import org.eclipse.sensinact.gateway.security.signature.internal.CryptographicUtils;
import org.eclipse.sensinact.gateway.security.signature.internal.SignatureBlock;
import org.eclipse.sensinact.gateway.security.signature.internal.SignatureFile;
import org.eclipse.sensinact.gateway.security.signature.internal.SignatureFileChecker;
import org.eclipse.sensinact.gateway.security.signature.internal.SignedBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedBundleChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SignedBundleChecker.class);
    private static final String METADATA_DIR = "/META-INF/";
    private static final String MF_FILE = "MANIFEST.MF";
    Mediator mediator;

    public SignedBundleChecker(Mediator mediator) {
        this.mediator = mediator;
    }

    protected boolean checkCoherence(SignedBundle signedJar, String signer, Certificate cert, CryptographicUtils cryptoUtils, String algo) throws Exception {
        boolean coherent = false;
        boolean resourcesOrderValid = false;
        boolean manifestValid = false;
        boolean signatureFileValid = false;
        boolean signatureBlockValid = false;
        resourcesOrderValid = this.checkResourcesOrderValid(signedJar);
        if (LOG.isInfoEnabled()) {
            LOG.info("resourcesOrderValid " + resourcesOrderValid);
        }
        signatureBlockValid = this.checkSignatureBlockValidity(signedJar, signer, cryptoUtils, algo);
        if (LOG.isInfoEnabled()) {
            LOG.info("signatureBlockValid " + signatureBlockValid);
        }
        signatureFileValid = this.checkSignatureFileValidity(signedJar, signer, cryptoUtils);
        if (LOG.isInfoEnabled()) {
            LOG.info("signatureFileValid " + signatureFileValid);
        }
        manifestValid = this.checkManifestValidity(signedJar, cryptoUtils);
        if (LOG.isWarnEnabled()) {
            LOG.info("manifestValid " + manifestValid);
        }
        boolean bl = coherent = resourcesOrderValid && signatureBlockValid && signatureFileValid && manifestValid;
        if (LOG.isWarnEnabled()) {
            LOG.info("coherent " + coherent);
        }
        return coherent;
    }

    protected boolean checkSignatureBlockValidity(SignatureFile sigFile, SignatureBlock block, X509Certificate cert, CryptographicUtils cryptoUtils, String algo) throws Exception {
        boolean blockValidity = false;
        if (cert == null) {
            if (LOG.isWarnEnabled()) {
                LOG.info("SignedJarFile.checkSignatureBlockValidity, no cert found");
            }
        } else {
            if (LOG.isWarnEnabled()) {
                LOG.info("SignedJarFile.checkSignatureBlockValidity, cert found");
            }
            cert.checkValidity();
            byte[] signatureFileData = sigFile.getBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("signature file: " + new String(signatureFileData) + ".");
            }
            byte[] signatureBlock = block.getEncoded();
            blockValidity = cryptoUtils.checkCMSDataValidity(signatureFileData, signatureBlock, algo);
        }
        if (LOG.isWarnEnabled()) {
            LOG.info("block validity: " + blockValidity);
        }
        return blockValidity;
    }

    private boolean checkSignatureBlockValidity(SignedBundle signedJar, String signer, CryptographicUtils cryptoUtils, String algo) throws Exception {
        X509Certificate cert = (X509Certificate)signedJar.getCertificate(signer);
        SignatureFile sigFile = signedJar.getSignatureFile(signer);
        SignatureBlock block = signedJar.getSignatureBlock(signer);
        return this.checkSignatureBlockValidity(sigFile, block, cert, cryptoUtils, algo);
    }

    protected boolean checkSignatureFileValidity(SignedBundle signedJar, SignatureFile sigFile, CryptographicUtils cryptoUtils) throws NoSuchAlgorithmException, IOException {
        boolean manifestEntriesValid = false;
        boolean manifestHashValid = false;
        if (sigFile != null) {
            sigFile.show();
            String hashValue = sigFile.getManifestHash();
            String hashAlgo = sigFile.getHashAlgo();
            manifestHashValid = cryptoUtils.checkHashValue(this.mediator, signedJar.getEntry("/META-INF/MANIFEST.MF"), hashValue, hashAlgo);
            LOG.debug("manifest hash valid: %s", (Object)manifestHashValid);
            manifestEntriesValid = SignatureFileChecker.checkEntriesValidity(this.mediator, signedJar, sigFile, cryptoUtils);
            if (LOG.isWarnEnabled()) {
                LOG.debug("entries hash valid: " + manifestEntriesValid);
            }
        }
        return manifestHashValid && manifestEntriesValid;
    }

    private boolean checkSignatureFileValidity(SignedBundle signedJar, String signer, CryptographicUtils cryptoUtils) throws IOException, NoSuchAlgorithmException {
        boolean validated = false;
        SignatureFile sigFile = signedJar.getSignatureFile(signer);
        if (sigFile != null) {
            if (LOG.isWarnEnabled()) {
                LOG.info("Signature File found");
            }
            validated = this.checkSignatureFileValidity(signedJar, sigFile, cryptoUtils);
        }
        return validated;
    }

    private boolean checkManifestValidity(SignedBundle signedJar, CryptographicUtils cryptoUtils) throws Exception {
        boolean validated;
        Manifest manifest = new Manifest();
        manifest.read(signedJar.getEntry("/META-INF/MANIFEST.MF").openStream());
        boolean manifestEntriesExist = this.checkManifestEntriesExist(signedJar, manifest);
        if (LOG.isInfoEnabled()) {
            LOG.info("manifestEntriesExist: " + manifestEntriesExist);
        }
        boolean resourcesKnownInManifest = this.checkResourcesKnownInManifest(signedJar, manifest);
        if (LOG.isInfoEnabled()) {
            LOG.info("resourcesKnownInManifest: " + resourcesKnownInManifest);
        }
        boolean hashValuesValid = false;
        if (manifestEntriesExist && resourcesKnownInManifest) {
            hashValuesValid = this.checkHashValuesValid(signedJar, manifest, cryptoUtils);
        }
        if (LOG.isWarnEnabled()) {
            LOG.info("hashValuesValid: " + hashValuesValid);
        }
        boolean bl = validated = manifestEntriesExist && resourcesKnownInManifest && hashValuesValid;
        if (LOG.isWarnEnabled()) {
            LOG.info("validated: " + validated);
        }
        return validated;
    }

    private boolean checkManifestEntriesExist(SignedBundle signedJar, Manifest manifest) throws IOException {
        boolean checked = true;
        Iterator<String> elements = manifest.getEntries().keySet().iterator();
        while (elements.hasNext() && checked) {
            String element = elements.next();
            if (signedJar.getEntry("/" + element) != null) continue;
            checked = false;
        }
        return checked;
    }

    protected boolean checkHashValuesValid(SignedBundle signedJar, Manifest manifest, CryptographicUtils cryptoUtils) throws BundleValidationException, ZipException, IOException, NoSuchAlgorithmException {
        boolean checked = true;
        Map<String, Attributes> entries = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
            String file = entry.getKey();
            if (LOG.isDebugEnabled()) {
                LOG.debug("file: " + file);
            }
            Attributes data = entries.get(file);
            for (Map.Entry<Object, Object> entry2 : data.entrySet()) {
                Attributes.Name key2 = (Attributes.Name)entry2.getKey();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("key2: " + key2);
                }
                String hashValue = (String)data.get(key2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("hashValue: " + hashValue);
                }
                String type = key2.toString();
                checked = checked && cryptoUtils.checkHashValue(this.mediator, signedJar.getEntry(file), hashValue, type);
            }
        }
        return checked;
    }

    private boolean checkResourcesKnownInManifest(SignedBundle signedJar, Manifest manifest) {
        boolean checked = true;
        List<URL> entries = signedJar.getEntries();
        Iterator<URL> iterator = entries.iterator();
        while (iterator.hasNext() && checked) {
            URL entry = iterator.next();
            String path = entry.getPath().substring(1);
            if (!path.endsWith(".class") || manifest.getAttributes(path) != null) continue;
            checked = false;
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn(path + " not referenced in the manifest file");
        }
        return checked;
    }

    private boolean[] checkEntry(URL entry, boolean sfFound, boolean orFound, boolean oValid) {
        boolean signatureFileFound = sfFound;
        boolean otherResourcesFound = orFound;
        boolean orderValid = oValid;
        String name = entry.getPath();
        if (!name.endsWith("/")) {
            if (name.endsWith("/META-INF/MANIFEST.MF")) {
                if (signatureFileFound || otherResourcesFound) {
                    orderValid = false;
                }
            } else if (name.endsWith(".SF") || name.endsWith(".RSA") || name.endsWith(".DSA")) {
                signatureFileFound = true;
                if (otherResourcesFound) {
                    orderValid = false;
                }
            } else {
                otherResourcesFound = true;
            }
        }
        boolean[] checkState = new boolean[]{signatureFileFound, otherResourcesFound, orderValid};
        return checkState;
    }

    private boolean checkResourcesOrderValid(SignedBundle signedJar) throws FileNotFoundException, IOException {
        boolean orderValid = false;
        Manifest manifest = signedJar.getManifest();
        if (manifest != null) {
            orderValid = true;
        }
        boolean signatureFileFound = false;
        boolean otherResourcesFound = false;
        List<URL> entries = signedJar.getEntries();
        for (URL entry : entries) {
            boolean[] checkState = this.checkEntry(entry, signatureFileFound, otherResourcesFound, orderValid);
            signatureFileFound = checkState[0];
            otherResourcesFound = checkState[1];
            orderValid = checkState[2];
        }
        return orderValid;
    }
}

