/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelInstance;
import org.eclipse.sensinact.gateway.generic.ExtResourceDescriptor;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskCallBack;
import org.eclipse.sensinact.gateway.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtServiceProviderImpl
extends ServiceProviderImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ExtServiceProviderImpl.class);

    protected ExtServiceProviderImpl(ExtModelInstance<?> modelInstance, String name) throws InvalidServiceProviderException {
        this(modelInstance, name, Collections.emptyList());
    }

    protected ExtServiceProviderImpl(ExtModelInstance<?> modelInstance, String name, List<String> serviceNames) throws InvalidServiceProviderException {
        super(modelInstance, name, serviceNames);
    }

    protected Task passOn(String type, String path, Object[] parameters) throws Exception {
        String[] pathElements = UriUtils.getUriElements((String)path);
        String service = null;
        String resource = null;
        if (pathElements.length > 2) {
            service = pathElements[1];
            resource = pathElements[2];
        }
        Task.CommandType command = Task.CommandType.valueOf(type);
        ResourceConfig resourceConfig = null;
        resourceConfig = ((ExtModelConfiguration)((ExtModelInstance)this.modelInstance).configuration()).getResourceConfig(new ExtResourceDescriptor().withServiceName(service).withResourceName(resource));
        Task task = ((ExtModelInstance)this.modelInstance).propagate(command, path, resourceConfig, parameters);
        if (task != null) {
            for (long wait = task.getTimeout(); !task.isResultAvailable() && wait > 0L; wait -= 150L) {
                try {
                    Thread.sleep(150L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    LOG.error(e.getMessage(), (Throwable)e);
                    break;
                }
            }
            if (!task.isResultAvailable()) {
                task.abort(AccessMethod.EMPTY);
            }
        }
        return task;
    }

    protected void doStart() throws Exception {
        Task task = ((ExtModelInstance)this.modelInstance).propagate(Task.CommandType.SERVICES_ENUMERATION, this.getPath(), null, null);
        if (task == null) {
            super.doStart();
            return;
        }
        task.registerCallBack(new TaskCallBack(new Executable<Task, Void>(){

            public Void execute(Task task) throws Exception {
                if (task.isResultAvailable()) {
                    Object serviceIds = task.getResult();
                    Class<?> componentType = null;
                    if (serviceIds != null && (componentType = serviceIds.getClass().getComponentType()) != null && componentType == String.class) {
                        int length = Array.getLength(serviceIds);
                        for (int index = 0; index < length; ++index) {
                            String serviceId = (String)Array.get(serviceIds, index);
                            ExtServiceProviderImpl.this.serviceNames.add(serviceId);
                        }
                    }
                } else {
                    task.abort(AccessMethod.EMPTY);
                    throw new InvalidServiceProviderException("services enumeration task timeout");
                }
                ExtServiceProviderImpl.super.doStart();
                return null;
            }
        }));
    }
}

