/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.security.access.impl;

import org.eclipse.sensinact.gateway.core.security.AccessLevel;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.AuthorizationService;
import org.eclipse.sensinact.gateway.core.security.AuthorizationServiceException;
import org.eclipse.sensinact.gateway.core.security.dao.AuthenticatedAccessLevelDAO;
import org.eclipse.sensinact.gateway.core.security.dao.DAOException;
import org.eclipse.sensinact.gateway.core.security.entity.AuthenticatedAccessLevelEntity;
import org.eclipse.sensinact.gateway.datastore.api.DataStoreException;

public class AuthorizationServiceImpl
implements AuthorizationService {
    private AuthenticatedAccessLevelDAO authenticatedAccessLevelDAO;

    public AuthorizationServiceImpl(AuthenticatedAccessLevelDAO authenticatedAccessLevelDAO) throws DAOException {
        this.authenticatedAccessLevelDAO = authenticatedAccessLevelDAO;
    }

    public AccessLevelOption getAuthenticatedAccessLevelOption(String path, long uid) throws AuthorizationServiceException {
        if (uid <= 0L) {
            return AccessLevelOption.ANONYMOUS;
        }
        try {
            AuthenticatedAccessLevelEntity userAccessLevelEntity = this.authenticatedAccessLevelDAO.find(path, uid);
            return AccessLevelOption.valueOf((AccessLevel)userAccessLevelEntity);
        }
        catch (DAOException | DataStoreException e) {
            throw new AuthorizationServiceException((Throwable)e);
        }
    }

    public AccessLevelOption getAuthenticatedAccessLevelOption(String path, String publicKey) throws AuthorizationServiceException {
        if (publicKey == null || publicKey.startsWith("anonymous")) {
            return AccessLevelOption.ANONYMOUS;
        }
        try {
            AuthenticatedAccessLevelEntity userAccessLevelEntity = this.authenticatedAccessLevelDAO.find(path, publicKey);
            return AccessLevelOption.valueOf((AccessLevel)userAccessLevelEntity);
        }
        catch (Exception e) {
            throw new AuthorizationServiceException((Throwable)e);
        }
    }
}

