/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.PayloadFragment;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.AbstractHttpDevicePacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.packet.TaskAwareHttpResponsePacket;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.MappingDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvPacketReader
extends AbstractHttpDevicePacketReader {
    private static final Logger LOG = LoggerFactory.getLogger(CsvPacketReader.class);
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("((TRUE)|(FALSE))");
    private static final Pattern INT_PATTERN = Pattern.compile("[0-9]+");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("([1-9][0-9]*(\\.[0-9]+)?)|(0(\\.[0-9]+)?)");
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final List<String> headers = new ArrayList<String>();
    private final char delimiterChar;
    private final boolean firstRowHeaders;
    private final NumberFormat numberLocale;
    private final Integer maxRows;
    private BufferedReader reader;
    private int currentRow;
    private String nextLine;

    public CsvPacketReader(SimpleDateFormat timestampFormat, String serviceProviderIdPattern, char delimiterChar, boolean firstRowHeaders, String csvNumberLocale, Integer maxRows) {
        super(timestampFormat, serviceProviderIdPattern);
        this.delimiterChar = delimiterChar;
        this.firstRowHeaders = firstRowHeaders;
        this.maxRows = maxRows;
        if (csvNumberLocale == null || "".equals(csvNumberLocale)) {
            this.numberLocale = null;
        } else {
            String[] segments = csvNumberLocale.split("_");
            switch (segments.length) {
                case 1: {
                    this.numberLocale = NumberFormat.getNumberInstance(new Locale(segments[0]));
                    break;
                }
                case 2: {
                    this.numberLocale = NumberFormat.getNumberInstance(new Locale(segments[0], segments[1]));
                    break;
                }
                case 3: {
                    this.numberLocale = NumberFormat.getNumberInstance(new Locale(segments[0], segments[1], segments[2]));
                    break;
                }
                default: {
                    LOG.error("The locale format {} is not valid", (Object)csvNumberLocale);
                    throw new IllegalArgumentException("The format " + csvNumberLocale + " is not valid");
                }
            }
        }
    }

    public void load(TaskAwareHttpResponsePacket packet) throws InvalidPacketException {
        MappingDescription[] rawMappings = packet.getMapping();
        if (Arrays.stream(rawMappings).anyMatch(m -> m.getMappingType() != 1)) {
            LOG.error("The configured mapping {} contains non-root mappings", (Object[])rawMappings);
            throw new InvalidPacketException("Only root mappings are supported for CSV parsing");
        }
        Arrays.stream(rawMappings).forEach(m -> this.mappings.putAll(m.getMapping()));
        try {
            this.reader = packet.getReader();
            this.advanceLine();
            if (this.firstRowHeaders && this.nextLine != null) {
                List<Object> tokenise = this.tokenise(this.nextLine, false);
                for (int i = 0; i < tokenise.size(); ++i) {
                    Object name = tokenise.get(i);
                    if (!"".equals(name)) {
                        this.headers.add((String)name);
                        continue;
                    }
                    this.headers.add(Integer.toString(i));
                }
                --this.currentRow;
                this.advanceLine();
            }
        }
        catch (Exception e) {
            if (this.reader != null) {
                this.safeClose(this.reader);
            }
            this.nextLine = null;
            LOG.error("Failed to initialize the CSV packet reader", (Throwable)e);
            throw new InvalidPacketException("Unable to read the packet", (Throwable)e);
        }
        if (this.nextLine == null) {
            this.safeClose(this.reader);
        }
    }

    private void advanceLine() throws IOException {
        if (this.maxRows != null && ++this.currentRow > this.maxRows) {
            this.nextLine = null;
            this.safeClose(this.reader);
        } else {
            do {
                this.nextLine = this.reader.readLine();
            } while ("".equals(this.nextLine));
            if (this.nextLine == null) {
                this.safeClose(this.reader);
            }
        }
    }

    private List<Object> tokenise(String line, boolean inferTypes) throws InvalidPacketException {
        ArrayList<Object> tokens = new ArrayList<Object>();
        int tokenStartIdx = 0;
        while (tokenStartIdx < line.length()) {
            if (line.charAt(tokenStartIdx) == this.delimiterChar) {
                tokens.add("");
                ++tokenStartIdx;
                continue;
            }
            boolean stripQuote = false;
            int tokenStopIdx = tokenStartIdx + 1;
            if (line.charAt(tokenStartIdx) == '\"') {
                stripQuote = true;
                if ((tokenStopIdx = line.indexOf(34, tokenStopIdx)) < 0) {
                    LOG.error("CSV Parsing failed. The line {} had an unbalanced \" starting at index {}", (Object)line, (Object)tokenStartIdx);
                    throw new InvalidPacketException("CSV parsing failed due to an unbalanced \" in the input");
                }
                if (tokenStopIdx < line.length() - 1 && line.charAt(tokenStopIdx + 1) != this.delimiterChar) {
                    LOG.error("CSV Parsing failed. The line {} had a quoted token starting at index {} and finishing at index {} that was not followed by a delimiter", new Object[]{line, tokenStartIdx, tokenStopIdx});
                    throw new InvalidPacketException("CSV parsing failed due to a misquoted token in the input");
                }
                ++tokenStopIdx;
            } else {
                tokenStopIdx = line.indexOf(this.delimiterChar, tokenStopIdx);
            }
            if (tokenStopIdx < 0) {
                tokenStopIdx = line.length();
            }
            String token = line.substring(stripQuote ? tokenStartIdx + 1 : tokenStartIdx, stripQuote ? tokenStopIdx - 1 : tokenStopIdx);
            tokens.add(inferTypes ? this.inferType(token) : token);
            tokenStartIdx = tokenStopIdx + 1;
        }
        return tokens;
    }

    private Object inferType(String token) {
        if (BOOLEAN_PATTERN.matcher(token.toUpperCase()).matches()) {
            return Boolean.parseBoolean(token);
        }
        if (this.numberLocale == null) {
            if (INT_PATTERN.matcher(token).matches()) {
                return Long.parseLong(token);
            }
            if (NUMBER_PATTERN.matcher(token).matches()) {
                return Double.parseDouble(token);
            }
        } else {
            ParsePosition pp = new ParsePosition(0);
            Number n = this.numberLocale.parse(token, pp);
            if (pp.getErrorIndex() == -1 && pp.getIndex() == token.length()) {
                return n;
            }
        }
        return token;
    }

    public void parse() throws InvalidPacketException {
    }

    public void reset() {
        if (this.reader != null) {
            this.safeClose(this.reader);
        }
        this.headers.clear();
        this.mappings.clear();
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("This PacketReader is not initialized");
        }
        if (this.nextLine == null) {
            try {
                this.advanceLine();
            }
            catch (IOException e) {
                this.safeClose(this.reader);
                LOG.error("Failed to parse a CSV packet.", (Throwable)e);
                throw new IllegalArgumentException("Unable to read the complete packet", e);
            }
        }
        return this.nextLine != null;
    }

    @Override
    public PayloadFragment next() {
        if (this.nextLine == null) {
            throw new NoSuchElementException("No next line of the CSV to parse");
        }
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            List<Object> tokens = this.tokenise(this.nextLine, true);
            for (int i = 0; i < tokens.size(); ++i) {
                Object token = tokens.get(i);
                if (i < this.headers.size()) {
                    data.put(this.headers.get(i), token);
                    continue;
                }
                data.put("[" + i + "]", token);
            }
            PayloadFragment payloadFragment = this.createFragments(data, this.mappings);
            return payloadFragment;
        }
        catch (InvalidPacketException e) {
            this.safeClose(this.reader);
            LOG.error("Failed to parse a CSV packet.", (Throwable)e);
            throw new IllegalArgumentException("Failed to read the complete packet", e);
        }
        finally {
            this.nextLine = null;
        }
    }
}

