/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.rsa.core.ClientServiceFactory;
import org.apache.aries.rsa.core.CloseHandler;
import org.apache.aries.rsa.core.ExportReferenceImpl;
import org.apache.aries.rsa.core.ExportRegistrationImpl;
import org.apache.aries.rsa.core.ImportRegistrationImpl;
import org.apache.aries.rsa.core.PackageUtil;
import org.apache.aries.rsa.core.event.EventProducer;
import org.apache.aries.rsa.spi.DistributionProvider;
import org.apache.aries.rsa.spi.Endpoint;
import org.apache.aries.rsa.util.EndpointHelper;
import org.apache.aries.rsa.util.StringPlus;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointPermission;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceAdminCore
implements RemoteServiceAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteServiceAdminCore.class);
    private final Map<Map<String, Object>, Collection<ExportRegistration>> exportedServices = new LinkedHashMap<Map<String, Object>, Collection<ExportRegistration>>();
    private final Map<EndpointDescription, Collection<ImportRegistration>> importedServices = new LinkedHashMap<EndpointDescription, Collection<ImportRegistration>>();
    private final List<ExportRegistration> exportInProgress = Collections.emptyList();
    private final BundleContext bctx;
    private final EventProducer eventProducer;
    private ServiceListener exportedServiceListener;
    private DistributionProvider provider;
    private BundleContext apictx;
    private PackageUtil packageUtil;
    private CloseHandler closeHandler;

    public RemoteServiceAdminCore(BundleContext context, BundleContext apiContext, EventProducer eventProducer, DistributionProvider provider, PackageUtil packageUtil) {
        this.bctx = context;
        this.apictx = apiContext;
        this.eventProducer = eventProducer;
        this.provider = provider;
        this.packageUtil = packageUtil;
        this.closeHandler = new CloseHandler(){

            @Override
            public void onClose(ExportRegistration exportReg) {
                RemoteServiceAdminCore.this.removeExportRegistration(exportReg);
            }

            @Override
            public void onClose(ImportRegistration importReg) {
                RemoteServiceAdminCore.this.removeImportRegistration(importReg);
            }
        };
        this.createServiceListener();
    }

    protected void createServiceListener() {
        this.exportedServiceListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 4) {
                    RemoteServiceAdminCore.this.removeServiceExports(event.getServiceReference());
                }
            }
        };
        this.bctx.addServiceListener(this.exportedServiceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExportRegistration> exportService(ServiceReference serviceReference, Map additionalProperties) throws IllegalArgumentException, UnsupportedOperationException {
        Map<String, Object> serviceProperties = this.getProperties(serviceReference);
        if (additionalProperties != null) {
            RemoteServiceAdminCore.overlayProperties(serviceProperties, additionalProperties);
        }
        Map<String, Object> key = this.makeKey(serviceProperties);
        List<String> interfaceNames = this.getInterfaceNames(serviceProperties);
        if (this.isImportedService(serviceReference) || !this.isExportConfigSupported(serviceProperties)) {
            return Collections.emptyList();
        }
        List<ExportRegistration> exportRegs = this.getExistingAndLock(key, interfaceNames);
        if (exportRegs != null) {
            return exportRegs;
        }
        try {
            ExportRegistration exportReg = this.exportService(interfaceNames, serviceReference, serviceProperties);
            exportRegs = new ArrayList<ExportRegistration>();
            if (exportReg != null) {
                exportRegs.add(exportReg);
            }
            this.store(key, exportRegs);
            List<ExportRegistration> list = exportRegs;
            return list;
        }
        finally {
            this.unlock(key);
        }
    }

    private boolean isExportConfigSupported(Map<String, Object> serviceProperties) {
        if (this.provider == null) {
            return false;
        }
        List exportedConfigs = StringPlus.normalize((Object)serviceProperties.get("service.exported.configs"));
        if (exportedConfigs == null || exportedConfigs.isEmpty()) {
            return true;
        }
        String[] supportedTypes = this.provider.getSupportedTypes();
        if (supportedTypes == null || supportedTypes.length == 0) {
            return true;
        }
        for (String supportedType : supportedTypes) {
            if (!exportedConfigs.contains(supportedType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Map<String, Object> key, List<ExportRegistration> exportRegs) {
        if (!exportRegs.isEmpty()) {
            Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
            synchronized (map) {
                this.exportedServices.put(key, new ArrayList<ExportRegistration>(exportRegs));
            }
            this.eventProducer.publishNotification(exportRegs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(Map<String, Object> key) {
        Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
        synchronized (map) {
            if (this.exportedServices.get(key) == this.exportInProgress) {
                this.exportedServices.remove(key);
            }
            this.exportedServices.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExportRegistration> getExistingAndLock(Map<String, Object> key, List<String> interfaces) {
        Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
        synchronized (map) {
            Collection<ExportRegistration> existingRegs = this.exportedServices.get(key);
            while (existingRegs == this.exportInProgress) {
                try {
                    this.exportedServices.wait();
                    existingRegs = this.exportedServices.get(key);
                }
                catch (InterruptedException ie) {
                    LOG.debug("interrupted while waiting for export in progress");
                    return Collections.emptyList();
                }
            }
            if (existingRegs != null) {
                LOG.debug("already exported this service. Returning existing exportRegs {} ", interfaces);
                return this.copyExportRegistration(existingRegs);
            }
            this.exportedServices.put(key, this.exportInProgress);
        }
        return null;
    }

    private ExportRegistration exportService(List<String> interfaceNames, ServiceReference<?> serviceReference, Map<String, Object> serviceProperties) {
        LOG.info("interfaces selected for export: " + interfaceNames);
        try {
            this.checkPermission(new EndpointPermission("*", "export"));
            Bundle serviceBundle = serviceReference.getBundle();
            if (serviceBundle == null) {
                throw new IllegalStateException("Service is already unregistered");
            }
            final BundleContext serviceContext = serviceBundle.getBundleContext();
            final Object serviceO = serviceContext.getService(serviceReference);
            if (serviceO == null) {
                throw new IllegalStateException("service object is null (service was unregistered?)");
            }
            final Class[] interfaces = this.getInterfaces(serviceO, interfaceNames);
            final Map<String, Object> eprops = this.createEndpointProps(serviceProperties, interfaces);
            Endpoint endpoint = AccessController.doPrivileged(new PrivilegedAction<Endpoint>(){

                @Override
                public Endpoint run() {
                    return RemoteServiceAdminCore.this.provider.exportService(serviceO, serviceContext, eprops, interfaces);
                }
            });
            if (endpoint == null) {
                return null;
            }
            return new ExportRegistrationImpl(serviceReference, endpoint, this.closeHandler, this.eventProducer);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            return new ExportRegistrationImpl(e, this.closeHandler, this.eventProducer);
        }
    }

    private Class<?>[] getInterfaces(Object service, List<String> interfaceNames) throws ClassNotFoundException {
        HashMap<String, Object> interfaces = new HashMap<String, Object>();
        for (Class<?> cls = service.getClass(); cls != null; cls = cls.getSuperclass()) {
            for (Class<?> interfaceClass : cls.getInterfaces()) {
                interfaces.put(interfaceClass.getName(), interfaceClass);
            }
        }
        ArrayList<Class> interfaceClasses = new ArrayList<Class>();
        for (String interfaceName : interfaceNames) {
            Class interfaceClass = (Class)interfaces.get(interfaceName);
            if (interfaceClass == null) {
                throw new ClassNotFoundException("Service class " + service.getClass() + " does not implement interface " + interfaceName);
            }
            interfaceClasses.add(interfaceClass);
        }
        return interfaceClasses.toArray(new Class[0]);
    }

    private List<String> getInterfaceNames(Map<String, Object> serviceProperties) {
        List providedInterfaces = StringPlus.normalize((Object)serviceProperties.get("objectClass"));
        if (providedInterfaces == null || providedInterfaces.isEmpty()) {
            throw new IllegalArgumentException("service is missing the objectClass property");
        }
        List exportedInterfaces = StringPlus.normalize((Object)serviceProperties.get("service.exported.interfaces"));
        if (exportedInterfaces == null || exportedInterfaces.isEmpty()) {
            throw new IllegalArgumentException("service is missing the service.exported.interfaces property");
        }
        ArrayList<String> interfaces = new ArrayList<String>(1);
        if (exportedInterfaces.size() == 1 && "*".equals(exportedInterfaces.get(0))) {
            interfaces.addAll(providedInterfaces);
        } else {
            List providedList = providedInterfaces;
            List allowedList = exportedInterfaces;
            if (!providedList.containsAll(allowedList)) {
                throw new IllegalArgumentException(String.format("exported interfaces %s must be a subset of the service's registered types %s", allowedList, providedList));
            }
            interfaces.addAll(exportedInterfaces);
        }
        return interfaces;
    }

    private Map<String, Object> makeKey(Map<String, Object> properties) {
        HashMap<String, Object> converted = new HashMap<String, Object>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            List<Object> val = entry.getValue();
            if (val instanceof Object[]) {
                val = Arrays.asList((Object[])val);
            }
            converted.put(entry.getKey(), val);
        }
        return converted;
    }

    private List<ExportRegistration> copyExportRegistration(Collection<ExportRegistration> regs) {
        HashSet<EndpointDescription> copiedEndpoints = new HashSet<EndpointDescription>();
        ArrayList<ExportRegistration> copy = new ArrayList<ExportRegistration>(regs.size());
        for (ExportRegistration exportRegistration : regs) {
            EndpointDescription epd;
            if (!(exportRegistration instanceof ExportRegistrationImpl)) continue;
            ExportRegistrationImpl exportRegistrationImpl = (ExportRegistrationImpl)exportRegistration;
            if (exportRegistration.getException() != null || copiedEndpoints.contains(epd = exportRegistration.getExportReference().getExportedEndpoint())) continue;
            copiedEndpoints.add(epd);
            copy.add(new ExportRegistrationImpl(exportRegistrationImpl));
        }
        regs.addAll(copy);
        this.eventProducer.publishNotification(copy);
        return copy;
    }

    private boolean isImportedService(ServiceReference<?> sref) {
        return sref.getProperty("service.imported") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExportReference> getExportedServices() {
        Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
        synchronized (map) {
            ArrayList<ExportReferenceImpl> ers = new ArrayList<ExportReferenceImpl>();
            for (Collection<ExportRegistration> exportRegistrations : this.exportedServices.values()) {
                for (ExportRegistration er : exportRegistrations) {
                    if (er.getExportReference() == null) continue;
                    ers.add(new ExportReferenceImpl(er.getExportReference()));
                }
            }
            return Collections.unmodifiableCollection(ers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ImportReference> getImportedEndpoints() {
        Map<EndpointDescription, Collection<ImportRegistration>> map = this.importedServices;
        synchronized (map) {
            ArrayList<ImportReference> irs = new ArrayList<ImportReference>();
            for (Collection<ImportRegistration> irl : this.importedServices.values()) {
                for (ImportRegistration impl : irl) {
                    irs.add(impl.getImportReference());
                }
            }
            return Collections.unmodifiableCollection(irs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportRegistration importService(EndpointDescription endpoint) {
        LOG.debug("importService() Endpoint: {}", endpoint.getProperties());
        Map<EndpointDescription, Collection<ImportRegistration>> map = this.importedServices;
        synchronized (map) {
            Collection<ImportRegistration> imRegs = this.importedServices.get(endpoint);
            if (imRegs != null && !imRegs.isEmpty()) {
                LOG.debug("creating copy of existing import registrations");
                ImportRegistration irParent = imRegs.iterator().next();
                ImportRegistrationImpl ir = new ImportRegistrationImpl(irParent);
                imRegs.add(ir);
                this.eventProducer.publishNotification(ir);
                return ir;
            }
            if (this.determineConfigTypesForImport(endpoint).size() == 0) {
                LOG.info("No matching handler can be found for remote endpoint {}.", (Object)endpoint.getId());
                return null;
            }
            List<String> matchingInterfaces = endpoint.getInterfaces();
            if (matchingInterfaces.size() == 0) {
                LOG.info("No matching interfaces found for remote endpoint {}.", (Object)endpoint.getId());
                return null;
            }
            LOG.info("Importing service {} with interfaces {} using handler {}.", new Object[]{endpoint.getId(), endpoint.getInterfaces(), this.provider.getClass()});
            ImportRegistrationImpl imReg = this.exposeServiceFactory(matchingInterfaces.toArray(new String[matchingInterfaces.size()]), endpoint, this.provider);
            if (imRegs == null) {
                imRegs = new ArrayList<ImportRegistration>();
                this.importedServices.put(endpoint, imRegs);
            }
            imRegs.add(imReg);
            this.eventProducer.publishNotification(imReg);
            return imReg;
        }
    }

    private List<String> determineConfigTypesForImport(EndpointDescription endpoint) {
        List<String> remoteConfigurationTypes = endpoint.getConfigurationTypes();
        ArrayList<String> usableConfigurationTypes = new ArrayList<String>();
        for (String ct : this.provider.getSupportedTypes()) {
            if (!remoteConfigurationTypes.contains(ct)) continue;
            usableConfigurationTypes.add(ct);
        }
        if (usableConfigurationTypes.size() == 0) {
            LOG.info("Ignoring endpoint {} as it has no compatible configuration types: {}.", (Object)endpoint.getId(), remoteConfigurationTypes);
        }
        return usableConfigurationTypes;
    }

    protected ImportRegistrationImpl exposeServiceFactory(String[] interfaceNames, EndpointDescription epd, DistributionProvider handler) {
        ImportRegistrationImpl imReg = new ImportRegistrationImpl(epd, this.closeHandler, this.eventProducer);
        try {
            EndpointDescription endpoint = imReg.getImportedEndpointDescription();
            Hashtable<String, Object> serviceProps = new Hashtable<String, Object>(endpoint.getProperties());
            ((Dictionary)serviceProps).put("service.imported", true);
            ((Dictionary)serviceProps).remove("service.exported.interfaces");
            ClientServiceFactory csf = new ClientServiceFactory(endpoint, handler, imReg);
            imReg.setClientServiceFactory(csf);
            ServiceRegistration csfReg = this.apictx.registerService(interfaceNames, (Object)csf, serviceProps);
            imReg.setImportedServiceRegistration(csfReg);
        }
        catch (Exception ex) {
            LOG.debug("Can not proxy service with interfaces " + Arrays.toString(interfaceNames) + ": " + ex.getMessage(), (Throwable)ex);
            imReg.setException(ex);
        }
        return imReg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeServiceExports(ServiceReference<?> sref) {
        ArrayList<ExportRegistration> regs = new ArrayList<ExportRegistration>(1);
        Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
        synchronized (map) {
            for (Collection<ExportRegistration> value : this.exportedServices.values()) {
                for (ExportRegistration er : value) {
                    if (!er.getExportReference().getExportedService().equals(sref)) continue;
                    regs.add(er);
                }
            }
            for (ExportRegistration er : regs) {
                LOG.debug("closing export for service {}", sref);
                er.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeExportRegistration(ExportRegistration eri) {
        Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
        synchronized (map) {
            Iterator<Collection<ExportRegistration>> it = this.exportedServices.values().iterator();
            while (it.hasNext()) {
                Collection<ExportRegistration> value = it.next();
                Iterator<ExportRegistration> it2 = value.iterator();
                while (it2.hasNext()) {
                    ExportRegistration er = it2.next();
                    if (!er.equals(eri)) continue;
                    this.eventProducer.notifyRemoval(eri.getExportReference());
                    it2.remove();
                    if (value.isEmpty()) {
                        it.remove();
                    }
                    return;
                }
            }
        }
    }

    protected void removeExportRegistrations(Bundle exportingBundle) {
        List<ExportRegistration> bundleExports = this.getExportsForBundle(exportingBundle);
        for (ExportRegistration export : bundleExports) {
            export.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImportRegistrations() {
        ArrayList<ImportRegistration> copy = new ArrayList<ImportRegistration>();
        Map<EndpointDescription, Collection<ImportRegistration>> map = this.importedServices;
        synchronized (map) {
            for (Collection<ImportRegistration> irs : this.importedServices.values()) {
                copy.addAll(irs);
            }
        }
        for (ImportRegistration ir : copy) {
            ir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExportRegistration> getExportsForBundle(Bundle exportingBundle) {
        Map<Map<String, Object>, Collection<ExportRegistration>> map = this.exportedServices;
        synchronized (map) {
            ArrayList<ExportRegistration> bundleRegs = new ArrayList<ExportRegistration>();
            for (Collection<ExportRegistration> regs : this.exportedServices.values()) {
                Bundle regBundle;
                ExportRegistration exportRegistration;
                if (regs.isEmpty() || (exportRegistration = regs.iterator().next()).getException() != null || !exportingBundle.equals(regBundle = exportRegistration.getExportReference().getExportedService().getBundle())) continue;
                bundleRegs.addAll(regs);
            }
            return bundleRegs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeImportRegistration(ImportRegistration iri) {
        Map<EndpointDescription, Collection<ImportRegistration>> map = this.importedServices;
        synchronized (map) {
            LOG.debug("Removing importRegistration {}", (Object)iri);
            ImportReference importRef = iri.getImportReference();
            if (importRef == null) {
                return;
            }
            EndpointDescription endpoint = importRef.getImportedEndpoint();
            Collection<ImportRegistration> imRegs = this.importedServices.get(endpoint);
            if (imRegs != null && imRegs.contains(iri)) {
                imRegs.remove(iri);
                this.eventProducer.notifyRemoval(iri);
            }
            if (imRegs == null || imRegs.isEmpty()) {
                this.importedServices.remove(endpoint);
            }
        }
    }

    public void close() {
        LOG.info("Closing " + this.getClass().getSimpleName());
        this.closeImportRegistrations();
        if (this.exportedServiceListener != null) {
            this.bctx.removeServiceListener(this.exportedServiceListener);
        }
    }

    static void overlayProperties(Map<String, Object> serviceProperties, Map<String, Object> additionalProperties) {
        HashMap<String, String> keysLowerCase = new HashMap<String, String>();
        for (String string : serviceProperties.keySet()) {
            keysLowerCase.put(string.toLowerCase(), string);
        }
        for (Map.Entry entry : additionalProperties.entrySet()) {
            String key = (String)entry.getKey();
            String lowerKey = key.toLowerCase();
            if ("service.id".toLowerCase().equals(lowerKey) || "objectClass".toLowerCase().equals(lowerKey)) {
                LOG.info("exportService called with additional properties map that contained illegal key: " + key + ", the key is ignored");
                continue;
            }
            String origKey = (String)keysLowerCase.get(lowerKey);
            if (origKey != null) {
                LOG.debug("Overwriting property [{}] with value [{}]", (Object)origKey, entry.getValue());
            } else {
                origKey = key;
                keysLowerCase.put(lowerKey, origKey);
            }
            serviceProperties.put(origKey, entry.getValue());
        }
    }

    private Map<String, Object> getProperties(ServiceReference<?> serviceReference) {
        String[] keys = serviceReference.getPropertyKeys();
        HashMap<String, Object> props = new HashMap<String, Object>(keys.length);
        for (String key : keys) {
            Object val = serviceReference.getProperty(key);
            props.put(key, val);
        }
        return props;
    }

    protected Map<String, Object> createEndpointProps(Map<String, Object> effectiveProps, Class<?>[] ifaces) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.copyEndpointProperties(effectiveProps, props);
        props.remove("service.id");
        EndpointHelper.addObjectClass(props, (Class[])ifaces);
        props.put("endpoint.service.id", effectiveProps.get("service.id"));
        String frameworkUUID = this.bctx.getProperty("org.osgi.framework.uuid");
        props.put("endpoint.framework.uuid", frameworkUUID);
        for (Class<?> iface : ifaces) {
            String pkg = iface.getPackage().getName();
            props.put("endpoint.package.version." + pkg, this.packageUtil.getVersion(iface));
        }
        return props;
    }

    private void copyEndpointProperties(Map<String, Object> sd, Map<String, Object> endpointProps) {
        Set<Map.Entry<String, Object>> keys = sd.entrySet();
        for (Map.Entry<String, Object> entry : keys) {
            String skey = entry.getKey();
            if (skey.startsWith(".")) continue;
            endpointProps.put(skey, entry.getValue());
        }
    }

    private void checkPermission(EndpointPermission permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(permission);
        }
    }
}

