/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.free.internal;

import org.eclipse.sensinact.gateway.generic.packet.annotation.AttributeID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Data;
import org.eclipse.sensinact.gateway.generic.packet.annotation.GoodbyeMessage;
import org.eclipse.sensinact.gateway.generic.packet.annotation.HelloMessage;
import org.eclipse.sensinact.gateway.generic.packet.annotation.Iteration;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ResourceID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ServiceID;
import org.eclipse.sensinact.gateway.generic.packet.annotation.ServiceProviderID;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;

public class FreeSmsPacket
extends HttpPacket {
    private String name;
    private String user;
    private String pass;
    private boolean appearance;
    private int position = 0;

    public FreeSmsPacket(String name, String user, String pass, boolean appearance) {
        super(new byte[0]);
        this.setName(name);
        this.setAppearance(appearance);
        this.setUser(user);
        this.setPass(pass);
    }

    @Iteration
    public boolean iteration() {
        return ++this.position >= 2;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ServiceProviderID
    public String getName() {
        return this.name;
    }

    @ServiceID
    public String getServiceID() {
        if (!this.isAppearance()) {
            return null;
        }
        return "SMS";
    }

    @ResourceID
    public String getResourceID() {
        if (!this.isAppearance()) {
            return null;
        }
        return "send";
    }

    @AttributeID
    public String getAttributeID() {
        if (!this.isAppearance()) {
            return null;
        }
        switch (this.position) {
            case 0: {
                return "user";
            }
            case 1: {
                return "pass";
            }
        }
        return null;
    }

    @Data
    public Object getData() {
        if (!this.isAppearance()) {
            return null;
        }
        switch (this.position) {
            case 0: {
                return this.getUser();
            }
            case 1: {
                return this.getPass();
            }
        }
        return null;
    }

    @HelloMessage
    public boolean isHelloMessage() {
        return this.isAppearance();
    }

    @GoodbyeMessage
    public boolean isGoodbyeMessage() {
        return !this.isAppearance();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public boolean isAppearance() {
        return this.appearance;
    }

    public void setAppearance(boolean appearance) {
        this.appearance = appearance;
    }
}

