/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceConfigCatalog;
import org.eclipse.sensinact.gateway.core.ResourceDescriptor;

public class ResourceConfigCatalogCollection {
    Deque<ResourceConfigCatalog> catalogs = new LinkedList<ResourceConfigCatalog>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ResourceConfigCatalog catalog) {
        if (catalog == null) {
            return;
        }
        Deque<ResourceConfigCatalog> deque = this.catalogs;
        synchronized (deque) {
            this.catalogs.add(catalog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ResourceConfigCatalog catalog) {
        if (catalog == null) {
            return;
        }
        Deque<ResourceConfigCatalog> deque = this.catalogs;
        synchronized (deque) {
            this.catalogs.remove(catalog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ResourceConfigCatalog> iterator() {
        ResourceConfigCatalog[] catalogsArray;
        Deque<ResourceConfigCatalog> deque = this.catalogs;
        synchronized (deque) {
            catalogsArray = new ResourceConfigCatalog[this.catalogs.size()];
            this.catalogs.toArray(catalogsArray);
        }
        return new Iterator<ResourceConfigCatalog>(){
            int position = 0;

            @Override
            public boolean hasNext() {
                return this.position < catalogsArray.length;
            }

            @Override
            public ResourceConfigCatalog next() {
                if (this.hasNext()) {
                    return catalogsArray[this.position++];
                }
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    public ResourceConfig getResourceConfig(ResourceDescriptor descriptor) {
        Iterator<ResourceConfigCatalog> iterator = this.iterator();
        ResourceConfig resourceConfig = null;
        while (iterator.hasNext()) {
            try {
                ResourceConfigCatalog catalog = iterator.next();
                Object g = catalog.getResourceConfig(descriptor);
                resourceConfig = (ResourceConfig)g;
                if (g == null) continue;
                break;
            }
            catch (ClassCastException e) {
            }
        }
        return resourceConfig;
    }
}

