/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.constraint.Constraint;
import org.eclipse.sensinact.gateway.common.props.TypedProperties;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SubscriptionFilter
extends SnaFilter {
    public SubscriptionFilter(Mediator mediator, String filter, Set<Constraint> conditions) {
        super(mediator, filter);
        super.addHandledType(SnaMessage.Type.UPDATE);
        if (conditions != null) {
            for (Constraint condition : conditions) {
                super.addCondition(condition);
            }
        }
    }

    public SubscriptionFilter(Mediator mediator, String filter, JSONArray conditions) {
        super(mediator, filter, conditions);
    }

    @Override
    public boolean matches(SnaMessage<?> message) {
        if (!super.matches(message)) {
            return false;
        }
        if (this.conditions.isEmpty()) {
            return true;
        }
        JSONObject jsonObject = (JSONObject)((TypedProperties)message).get("notification");
        String type = jsonObject.getString("type");
        Class clazz = null;
        try {
            clazz = CastUtils.loadClass((ClassLoader)this.mediator.getClassLoader(), (String)type);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        Object object = CastUtils.cast((Class)clazz, (Object)jsonObject.opt("value"));
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            if (((Constraint)iterator.next()).complies(object)) continue;
            return false;
        }
        return true;
    }
}

