/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.ttn.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.sthbnd.ttn.model.TtnGateway;
import org.json.JSONException;
import org.json.JSONObject;

public class TtnMetadata {
    private final String time;
    private final double frequency;
    private final String modulation;
    private final String dataRate;
    private final String codingRate;
    private final List<?> gateways;

    public TtnMetadata(String time, long frequency, String modulation, String dataRate, String codingRate, List<?> gateways) {
        this.time = time;
        this.frequency = frequency;
        this.modulation = modulation;
        this.dataRate = dataRate;
        this.codingRate = codingRate;
        this.gateways = gateways;
    }

    public TtnMetadata(JSONObject json) throws JSONException {
        this.time = json.getString("time");
        this.frequency = json.getDouble("frequency");
        this.modulation = json.getString("modulation");
        this.dataRate = json.getString("data_rate");
        this.codingRate = json.getString("coding_rate");
        ArrayList gateways = new ArrayList();
        for (int i = 0; i < json.getJSONArray("gateways").length(); ++i) {
            gateways.add(new TtnGateway(json.getJSONArray("gateways").getJSONObject(i)));
        }
        this.gateways = gateways;
    }

    public String getTime() {
        return this.time;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public String getModulation() {
        return this.modulation;
    }

    public String getDataRate() {
        return this.dataRate;
    }

    public String getCodingRate() {
        return this.codingRate;
    }

    public List<?> getGateways() {
        return this.gateways;
    }

    public Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("frequency", this.frequency);
        data.put("modulation", this.modulation);
        data.put("data_rate", this.dataRate);
        data.put("coding_rate", this.codingRate);
        return data;
    }
}

