/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.aries.rsa.provider.fastbin.api.AsyncCallback;
import org.apache.aries.rsa.provider.fastbin.api.SerializationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.AbstractInvocationStrategy;
import org.apache.aries.rsa.provider.fastbin.tcp.ResponseFuture;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncInvocationStrategy
extends AbstractInvocationStrategy {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AsyncInvocationStrategy.class);

    @Override
    protected void encodeRequest(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args, DataByteArrayOutputStream requestStream) throws Exception {
        Class<?>[] new_types = AsyncInvocationStrategy.payloadTypes(method);
        Object[] new_args = new Object[args.length - 1];
        System.arraycopy(args, 0, new_args, 0, new_args.length);
        serializationStrategy.encodeRequest(loader, new_types, new_args, requestStream);
    }

    @Override
    protected ResponseFuture createResponse(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object[] args) throws Exception {
        return new AsyncResponseFuture(loader, method, (AsyncCallback)args[args.length - 1], serializationStrategy, Dispatch.getCurrentQueue());
    }

    @Override
    protected Class getResultType(Method method) {
        Type[] types = method.getGenericParameterTypes();
        ParameterizedType t = (ParameterizedType)types[types.length - 1];
        return (Class)t.getActualTypeArguments()[0];
    }

    private static Class<?>[] payloadTypes(Method method) {
        Class<?>[] types = method.getParameterTypes();
        Class[] new_types = new Class[types.length - 1];
        System.arraycopy(types, 0, new_types, 0, new_types.length);
        return new_types;
    }

    @Override
    protected void doService(SerializationStrategy serializationStrategy, ClassLoader loader, Method method, Object target, DataByteArrayInputStream requestStream, DataByteArrayOutputStream responseStream, Runnable onComplete) {
        final AbstractInvocationStrategy.AsyncServiceResponse helper = new AbstractInvocationStrategy.AsyncServiceResponse(loader, method, responseStream, onComplete, serializationStrategy);
        try {
            Object[] new_args = new Object[method.getParameterTypes().length];
            serializationStrategy.decodeRequest(loader, AsyncInvocationStrategy.payloadTypes(method), requestStream, new_args);
            new_args[new_args.length - 1] = new AsyncCallback<Object>(){

                @Override
                public void onSuccess(Object result) {
                    helper.send(null, result);
                }

                @Override
                public void onFailure(Throwable failure) {
                    helper.send(failure, null);
                }
            };
            method.invoke(target, new_args);
        }
        catch (Throwable t) {
            helper.send(t, null);
        }
    }

    private class AsyncResponseFuture
    implements ResponseFuture {
        private final ClassLoader loader;
        private final Method method;
        private final AsyncCallback callback;
        private final SerializationStrategy serializationStrategy;
        private final DispatchQueue queue;

        public AsyncResponseFuture(ClassLoader loader, Method method, AsyncCallback callback, SerializationStrategy serializationStrategy, DispatchQueue queue) {
            this.loader = loader;
            this.method = method;
            this.callback = callback;
            this.serializationStrategy = serializationStrategy;
            this.queue = queue;
        }

        @Override
        public void set(final DataByteArrayInputStream source) {
            if (this.queue != null) {
                this.queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        AsyncResponseFuture.this.decodeIt(source);
                    }
                });
            } else {
                this.decodeIt(source);
            }
        }

        private void decodeIt(DataByteArrayInputStream source) {
            try {
                this.serializationStrategy.decodeResponse(this.loader, AsyncInvocationStrategy.this.getResultType(this.method), source, this.callback);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }

        @Override
        public void fail(Throwable throwable) {
            this.callback.onFailure(throwable);
        }
    }
}

