/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.aries.rsa.provider.fastbin.io.ProtocolCodec;
import org.fusesource.hawtbuf.Buffer;

public class LengthPrefixedCodec
implements ProtocolCodec {
    private static final int MAX_PACKET_SIZE = Integer.getInteger("aries.fastbin.max.packet.bytes", 0xA00000) <= 0 ? Integer.MAX_VALUE : Integer.getInteger("aries.fastbin.max.packet.bytes", 0xA00000);
    final int write_buffer_size = 65536;
    long write_counter = 0L;
    WritableByteChannel write_channel;
    final Queue<ByteBuffer> next_write_buffers = new LinkedList<ByteBuffer>();
    int next_write_size = 0;
    long read_counter = 0L;
    int read_buffer_size = 65536;
    ReadableByteChannel read_channel = null;
    ByteBuffer read_buffer = ByteBuffer.allocate(4);

    @Override
    public boolean full() {
        return false;
    }

    protected boolean empty() {
        if (this.next_write_size > 0) {
            return false;
        }
        if (!this.next_write_buffers.isEmpty()) {
            for (ByteBuffer b : this.next_write_buffers) {
                if (b.remaining() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setWritableByteChannel(WritableByteChannel channel) {
        this.write_channel = channel;
        if (channel instanceof SocketChannel) {
            try {
                ((SocketChannel)channel).socket().setSendBufferSize(65536);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ProtocolCodec.BufferState write(Object value) throws IOException {
        if (this.full()) {
            return ProtocolCodec.BufferState.FULL;
        }
        boolean wasEmpty = this.empty();
        Buffer buffer = (Buffer)value;
        this.next_write_size += buffer.length;
        this.next_write_buffers.add(buffer.toByteBuffer());
        return wasEmpty ? ProtocolCodec.BufferState.WAS_EMPTY : ProtocolCodec.BufferState.NOT_EMPTY;
    }

    @Override
    public ProtocolCodec.BufferState flush() throws IOException {
        long writeCounterBeforeFlush = this.write_counter;
        while (!this.next_write_buffers.isEmpty()) {
            ByteBuffer nextBuffer = this.next_write_buffers.peek();
            if (nextBuffer.remaining() < 1) {
                this.next_write_buffers.remove();
                continue;
            }
            int bytesWritten = this.write_channel.write(nextBuffer);
            this.write_counter += (long)bytesWritten;
            this.next_write_size -= bytesWritten;
            if (nextBuffer.remaining() <= 0) continue;
            break;
        }
        if (this.empty()) {
            if (writeCounterBeforeFlush == this.write_counter) {
                return ProtocolCodec.BufferState.WAS_EMPTY;
            }
            return ProtocolCodec.BufferState.EMPTY;
        }
        return ProtocolCodec.BufferState.NOT_EMPTY;
    }

    @Override
    public long getWriteCounter() {
        return this.write_counter;
    }

    @Override
    public void setReadableByteChannel(ReadableByteChannel channel) {
        this.read_channel = channel;
        if (channel instanceof SocketChannel) {
            try {
                ((SocketChannel)channel).socket().setReceiveBufferSize(this.read_buffer_size);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object read() throws IOException {
        while (true) {
            if (this.read_buffer.remaining() != 0) {
                int count = this.read_channel.read(this.read_buffer);
                if (count == -1) {
                    throw new EOFException("Peer disconnected");
                }
                if (count == 0) {
                    return null;
                }
                this.read_counter += (long)count;
                continue;
            }
            this.read_buffer.flip();
            if (this.read_buffer.capacity() != 4) break;
            int size = this.read_buffer.getInt(0);
            if (size < 4) {
                throw new ProtocolException("Expecting a size greater than 3");
            }
            if (size > MAX_PACKET_SIZE) {
                throw new ProtocolException("Packet length was declared as " + size + " but at most " + MAX_PACKET_SIZE + "is allowed. You can configure this limit with the system property aries.fastbin.max.packet.bytes");
            }
            if (size == 4) {
                Buffer rc = new Buffer(this.read_buffer);
                this.read_buffer = ByteBuffer.allocate(4);
                return rc;
            }
            ByteBuffer next = ByteBuffer.allocate(size);
            next.putInt(size);
            this.read_buffer = next;
        }
        Buffer rc = new Buffer(this.read_buffer);
        this.read_buffer = ByteBuffer.allocate(4);
        return rc;
    }

    @Override
    public long getReadCounter() {
        return this.read_counter;
    }
}

