/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class IOUtils {
    private static final Logger LOGGER = Logger.getLogger(IOUtils.class.getCanonicalName());
    private static final int BUFFER_SIZE = 65536;
    private static final int UNLIMITED = -1;

    public static byte[] read(InputStream input) {
        return IOUtils.read(input, -1, true);
    }

    public static byte[] read(InputStream input, boolean closeable) {
        return IOUtils.read(input, -1, closeable);
    }

    public static byte[] read(InputStream input, int size) {
        return IOUtils.read(input, size, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(InputStream input, int size, boolean closeable) {
        int read = 0;
        int length = 0;
        byte[] content = new byte[length];
        byte[] buffer = new byte[65536];
        try {
            while (size <= -1 || length < size) {
                read = input.read(buffer);
                if (read == -1) {
                    break;
                }
                byte[] newContent = new byte[length + read];
                if (length > 0) {
                    System.arraycopy(content, 0, newContent, 0, length);
                }
                System.arraycopy(buffer, 0, newContent, length, read);
                content = newContent;
                newContent = null;
                length += read;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
        finally {
            if (closeable) {
                try {
                    input.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.CONFIG, e.getMessage(), e);
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] content, OutputStream output) {
        int length = content == null ? 0 : content.length;
        int block = 65536;
        try {
            for (int written = 0; written < length; written += block) {
                if (written + block > length) {
                    block = length - written;
                }
                output.write(content, written, block);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.CONFIG, e.getMessage(), e);
            }
        }
    }
}

