/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.tools.connector.influxdb;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.sensinact.gateway.tools.connector.influxdb.InfluxDBTagDTO;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public class InfluxDbDatabase {
    private static final long MILLISECOND = TimeUnit.MILLISECONDS.toMillis(1L);
    private static final long SECOND = TimeUnit.SECONDS.toMillis(1L);
    private static final long MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long HOUR = TimeUnit.HOURS.toMillis(1L);
    private static final long DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long WEEK = DAY * 7L;
    private InfluxDB influxDB;
    private String database;

    public InfluxDbDatabase(InfluxDB influxDB, String database) {
        this(influxDB, database, "autogen");
    }

    public InfluxDbDatabase(InfluxDB influxDB, String database, String retention) {
        this.influxDB = influxDB;
        this.database = database;
        influxDB.setDatabase(database);
        influxDB.setRetentionPolicy(retention);
    }

    public void add(String measurement, Dictionary<String, String> tags, Object value) {
        this.add(measurement, tags, null, value, System.currentTimeMillis());
    }

    public void add(String measurement, Dictionary<String, String> tags, Dictionary<String, Object> fields, Object value) {
        this.add(measurement, tags, fields, value, System.currentTimeMillis());
    }

    public void add(String measurement, Dictionary<String, String> tags, Dictionary<String, Object> fields, Object value, long timestamp) {
        Point point = null;
        Point.Builder builder = Point.measurement(measurement);
        if (tags != null && !tags.isEmpty()) {
            for (String key : Collections.list(tags.keys())) {
                builder.tag(key, tags.get(key));
            }
        }
        builder.time(timestamp, TimeUnit.MILLISECONDS);
        if (fields != null && !fields.isEmpty()) {
            for (String key : Collections.list(fields.keys())) {
                this.addField(builder, key, fields.get(key));
            }
        }
        this.addField(builder, "value", value);
        point = builder.build();
        this.influxDB.write(point);
        this.influxDB.flush();
    }

    private void addField(Point.Builder builder, String key, Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass().isPrimitive()) {
            switch (value.getClass().getName()) {
                case "byte": {
                    builder.addField(key, (Byte)value);
                    break;
                }
                case "short": {
                    builder.addField(key, (Short)value);
                    break;
                }
                case "int": {
                    builder.addField(key, (Integer)value);
                    break;
                }
                case "long": {
                    builder.addField(key, (Long)value);
                    break;
                }
                case "float": {
                    builder.addField(key, Float.valueOf(((Float)value).floatValue()));
                    break;
                }
                case "double": {
                    builder.addField(key, (Double)value);
                    break;
                }
                case "char": {
                    builder.addField(key, new String(new char[]{((Character)value).charValue()}));
                    break;
                }
                case "boolean": {
                    builder.addField(key, (Boolean)value);
                }
            }
        } else if (value instanceof String) {
            builder.addField(key, (String)value);
        } else if (value instanceof Number) {
            switch (value.getClass().getName()) {
                case "java.lang.Byte": {
                    builder.addField(key, (Byte)value);
                    break;
                }
                case "java.lang.Short": {
                    builder.addField(key, (Short)value);
                    break;
                }
                case "java.lang.Integer": {
                    builder.addField(key, (Integer)value);
                    break;
                }
                case "java.lang.Long": {
                    builder.addField(key, (Long)value);
                    break;
                }
                case "java.lang.Float": {
                    builder.addField(key, (Float)value);
                    break;
                }
                case "java.lang.Double": {
                    builder.addField(key, (Double)value);
                    break;
                }
                case "java.lang.Character": {
                    builder.addField(key, value.toString());
                    break;
                }
                case "java.lang.Boolean": {
                    builder.addField(key, (Boolean)value);
                }
            }
        } else if (value instanceof Enum) {
            builder.addField(key, ((Enum)value).name());
        } else {
            builder.addField(key, String.valueOf(value));
        }
    }

    private String getTimeWindow(long timeWindow) {
        long measure;
        int pos;
        if (timeWindow <= MILLISECOND) {
            return "";
        }
        long[] measures = new long[]{WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND};
        long d = 0L;
        for (pos = 0; pos < measures.length && (timeWindow <= (measure = measures[pos]) || (d = timeWindow / measure) * measure != timeWindow); ++pos) {
            d = 0L;
        }
        switch (pos) {
            case 0: {
                return String.format(" group by time(%sw)", d);
            }
            case 1: {
                return String.format(" group by time(%sd)", d);
            }
            case 2: {
                return String.format(" group by time(%sh)", d);
            }
            case 3: {
                return String.format(" group by time(%sm)", d);
            }
            case 4: {
                return String.format(" group by time(%ss)", d);
            }
            case 5: {
                return String.format(" group by time(%sms)", d);
            }
        }
        return "";
    }

    private String getSelectFunction(String column, String function) {
        String select = null;
        if (column == null || column.trim().length() == 0) {
            return null;
        }
        if (function == null) {
            return column;
        }
        switch (function) {
            case "avg": 
            case "mean": {
                select = String.format("MEAN(%s)", column);
                break;
            }
            case "count": {
                select = String.format("COUNT(%s)", column);
                break;
            }
            case "countDistinct": {
                select = String.format("COUNT(DISTINCT(%s))", column);
                break;
            }
            case "distinct": {
                select = String.format("DISTINCT(%s)", column);
                break;
            }
            case "max": {
                select = String.format("MAX(%s)", column);
                break;
            }
            case "median": {
                select = String.format("MEDIAN(%s)", column);
                break;
            }
            case "min": {
                select = String.format("MIN(%s)", column);
                break;
            }
            case "sum_square": 
            case "sqsum": {
                select = String.format("SQRT(SUM(%s))", column, column);
                break;
            }
            case "sum": {
                select = String.format("SUM(%s)", column);
                break;
            }
            default: {
                select = column;
            }
        }
        return select;
    }

    private String buildWhereClause(List<InfluxDBTagDTO> tags) {
        String where = null;
        if (tags == null || tags.isEmpty()) {
            where = "";
            return where;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" WHERE ");
        for (int i = 0; i < tags.size(); ++i) {
            InfluxDBTagDTO t = tags.get(i);
            if (i > 0) {
                builder.append(" AND ");
            }
            builder.append(t.name);
            builder.append(t.pattern ? "=~" : "=");
            builder.append(t.pattern ? " " : "'");
            builder.append(t.value);
            builder.append(t.pattern ? " " : "'");
        }
        where = builder.toString();
        return where;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, List<String> columns) {
        String select = null;
        select = columns == null || columns.isEmpty() ? "* " : columns.stream().collect(StringBuilder::new, (b, s) -> {
            b.append((String)s);
            b.append(",");
        }, (h, t) -> h.append(t.toString())).toString();
        select = select.substring(0, select.length() - 1);
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        Query query = new Query(String.format("SELECT %s%s%s", select, from, where), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, String column, String function, long timeWindow) {
        String select = this.getSelectFunction(column, function);
        if (select == null) {
            return null;
        }
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        String window = this.getTimeWindow(timeWindow);
        Query query = new Query(String.format("SELECT %s%s%s%s", select, from, where, window), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, List<String> columns, ZonedDateTime start) {
        if (start == null) {
            return this.getResult(measurement, tags, columns);
        }
        String select = null;
        select = columns == null || columns.isEmpty() ? "* " : columns.stream().collect(StringBuilder::new, (b, s) -> {
            b.append((String)s);
            b.append(",");
        }, (h, t) -> h.append(t.toString())).toString();
        select = select.substring(0, select.length() - 1);
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        String startDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start.toInstant().atOffset(ZoneOffset.UTC));
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s'", startDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s'", startDate));
            where = builder.toString();
        }
        Query query = new Query(String.format("SELECT %s%s%s", select, from, where), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, String column, String function, long timeWindow, ZonedDateTime start) {
        if (start == null) {
            return this.getResult(measurement, tags, column, function, timeWindow);
        }
        String select = this.getSelectFunction(column, function);
        if (select == null) {
            return null;
        }
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        String startDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start.toInstant().atOffset(ZoneOffset.UTC));
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s'", startDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s'", startDate));
            where = builder.toString();
        }
        String window = this.getTimeWindow(timeWindow);
        Query query = new Query(String.format("SELECT %s%s%s%s", select, from, where, window), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, List<String> columns, ZonedDateTime start, ZonedDateTime end) {
        if (end == null) {
            return this.getResult(measurement, tags, columns, start);
        }
        String select = null;
        select = columns == null || columns.isEmpty() ? "* " : columns.stream().collect(StringBuilder::new, (b, s) -> {
            b.append((String)s);
            b.append(",");
        }, (h, t) -> h.append(t.toString())).toString();
        select = select.substring(0, select.length() - 1);
        String startDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start.toInstant().atOffset(ZoneOffset.UTC));
        String endDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(end.toInstant().atOffset(ZoneOffset.UTC));
        String from = String.format(" FROM %s ", measurement);
        String where = this.buildWhereClause(tags);
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s' AND time < '%s'", startDate, endDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s' AND time < '%s'", startDate, endDate));
            where = builder.toString();
        }
        Query query = new Query(String.format("SELECT %s%s%s", select, from, where), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getResult(String measurement, List<InfluxDBTagDTO> tags, String column, String function, long timeWindow, ZonedDateTime start, ZonedDateTime end) {
        if (end == null) {
            return this.getResult(measurement, tags, column, function, timeWindow, start);
        }
        String select = this.getSelectFunction(column, function);
        if (select == null) {
            return null;
        }
        String from = String.format(" FROM %s ", measurement);
        String startDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(start.toInstant().atOffset(ZoneOffset.UTC));
        String endDate = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(end.toInstant().atOffset(ZoneOffset.UTC));
        String where = this.buildWhereClause(tags);
        if (where.length() == 0) {
            where = String.format(" WHERE time > '%s' AND time < '%s'", startDate, endDate);
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(where);
            builder.append(String.format(" AND time > '%s' AND time < '%s'", startDate, endDate));
            where = builder.toString();
        }
        String window = this.getTimeWindow(timeWindow);
        Query query = new Query(String.format("SELECT %s%s%s%s", select, from, where, window), this.database);
        QueryResult result = this.influxDB.query(query);
        return result;
    }

    public QueryResult getPointInTimeResults(List<String> measurements, List<List<InfluxDBTagDTO>> tags, ZonedDateTime time) {
        String measure = measurements.stream().collect(Collectors.joining(","));
        String t = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time.toInstant().atOffset(ZoneOffset.UTC));
        String query = tags.stream().map(this::buildWhereClause).map(w -> String.format("SELECT path, time, value FROM %s %s AND time < '%s' limit 1;", measure, w, t)).collect(Collectors.joining(" "));
        return this.influxDB.query(new Query(query, this.database));
    }
}

