/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task;

import org.eclipse.sensinact.gateway.common.execution.Executable;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.protocol.http.client.Request;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpResponse;
import org.eclipse.sensinact.gateway.sthbnd.http.task.HttpDiscoveryTask;
import org.eclipse.sensinact.gateway.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthenticationTask<RESPONSE extends HttpResponse, REQUEST extends Request<RESPONSE>>
extends HttpDiscoveryTask<RESPONSE, REQUEST> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpAuthenticationTask.class);
    private static final String AUTHENTICATION_HEADER_KEY = "X-Auth-Token";
    private String authenticationHeaderKey;
    private Executable<Object, String> tokenExtractor;

    public HttpAuthenticationTask(HttpProtocolStackEndpoint transmitter, Class<REQUEST> requestType) {
        super(transmitter, requestType);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    public void registerTokenExtractor(Executable<Object, String> tokenExtractor) {
        this.tokenExtractor = tokenExtractor;
    }

    public void setAuthenticationHeaderKey(String authenticationHeaderKey) {
        this.authenticationHeaderKey = authenticationHeaderKey;
    }

    private void registerAuthenticationHeader(String token) {
        if (token == null || token.length() == 0) {
            return;
        }
        String key = null;
        key = this.authenticationHeaderKey;
        if (key == null) {
            key = AUTHENTICATION_HEADER_KEY;
        }
        ((HttpProtocolStackEndpoint)this.transmitter).registerPermanentHeader(key, token);
    }

    public void setResult(Object result, long timestamp) {
        super.setResult(result, timestamp);
        if (this.result != null && this.result == AccessMethod.EMPTY) {
            return;
        }
        String value = null;
        try {
            value = this.tokenExtractor == null ? (String)CastUtils.cast(String.class, (Object)result) : (String)this.tokenExtractor.execute(result);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.registerAuthenticationHeader(value);
    }
}

