/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.task.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.sthbnd.http.HttpPacket;
import org.eclipse.sensinact.gateway.sthbnd.http.annotation.HttpChildTaskConfiguration;
import org.eclipse.sensinact.gateway.sthbnd.http.smpl.HttpTaskConfigurator;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.HttpTaskConfigurationDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.KeyValuePairDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.NestedMappingDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.task.config.RootMappingDescription;

public class HttpChildTaskConfigurationDescription
extends HttpTaskConfigurationDescription {
    public static final String DEFAULT_ACCEPT_TYPE = "#EMPTY#";
    public static final String DEFAULT_CONTENT_TYPE = "#EMPTY#";
    public static final String DEFAULT_SCHEME = "#EMPTY#";
    public static final String DEFAULT_HTTP_METHOD = "#EMPTY#";
    public static final String DEFAULT_PORT = "#EMPTY#";
    public static final String DEFAULT_PATH = "#EMPTY#";
    public static final String DEFAULT_HOST = "#EMPTY#";
    public static final int DEFAULT_CONNECTION_TIMEOUT = -1;
    public static final int DEFAULT_READ_TIMEOUT = -1;
    public static final NestedMappingDescription[] DEFAULT_NESTED_MAPPING = new NestedMappingDescription[0];
    public static final RootMappingDescription[] DEFAULT_ROOT_MAPPING = new RootMappingDescription[0];
    @JsonProperty(value="identifier")
    private String identifier;

    public static List<HttpChildTaskConfigurationDescription> toDescription(HttpChildTaskConfiguration[] httpChildTaskConfigurations) {
        ArrayList<HttpChildTaskConfigurationDescription> description = new ArrayList<HttpChildTaskConfigurationDescription>();
        if (httpChildTaskConfigurations == null || httpChildTaskConfigurations.length == 0) {
            return description;
        }
        for (HttpChildTaskConfiguration config : httpChildTaskConfigurations) {
            description.add(HttpChildTaskConfigurationDescription.toDescription(config));
        }
        return description;
    }

    public static HttpChildTaskConfigurationDescription toDescription(HttpChildTaskConfiguration httpChildTaskConfiguration) {
        HttpChildTaskConfigurationDescription description = new HttpChildTaskConfigurationDescription();
        description.setAcceptType(httpChildTaskConfiguration.acceptType());
        description.setClientSSLCertificate(httpChildTaskConfiguration.clientSSLCertificate());
        description.setClientSSLCertificatePassword(httpChildTaskConfiguration.clientSSLCertificatePassword());
        description.setContent(httpChildTaskConfiguration.content());
        description.setContentType(httpChildTaskConfiguration.contentType());
        description.setDirect(httpChildTaskConfiguration.direct());
        description.setHeaders(KeyValuePairDescription.toDescription(httpChildTaskConfiguration.headers()));
        description.setHost(httpChildTaskConfiguration.host());
        description.setHttpMethod(httpChildTaskConfiguration.httpMethod());
        description.setPacket(httpChildTaskConfiguration.packet());
        description.setPath(httpChildTaskConfiguration.path());
        description.setPort(httpChildTaskConfiguration.port());
        description.setQuery(KeyValuePairDescription.toDescription(httpChildTaskConfiguration.query()));
        description.setScheme(httpChildTaskConfiguration.scheme());
        description.setServerSSLCertificate(httpChildTaskConfiguration.serverSSLCertificate());
        description.setIdentifier(httpChildTaskConfiguration.identifier());
        description.setConnectTimeout(httpChildTaskConfiguration.connectTimeout());
        description.setReadTimeout(httpChildTaskConfiguration.readTimeout());
        return description;
    }

    public HttpChildTaskConfigurationDescription() {
    }

    public HttpChildTaskConfigurationDescription(String acceptType, String contentType, String httpMethod, String scheme, String host, String port, String path, boolean direct, String clientSSLCertificate, String clientSSLCertificatePassword, String serverSSLCertificate, List<KeyValuePairDescription> query, List<KeyValuePairDescription> headers, Class<? extends HttpTaskConfigurator> content, Class<? extends HttpPacket> packet, int readTimeout, int connectTimeout, String identifier, RootMappingDescription[] rootMapping, NestedMappingDescription[] nestedMapping) {
        super(acceptType, contentType, httpMethod, scheme, host, port, path, direct, clientSSLCertificate, clientSSLCertificatePassword, serverSSLCertificate, query, headers, content, packet, readTimeout, connectTimeout, rootMapping, nestedMapping);
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public String getAcceptType() {
        if (this.acceptType == null) {
            return "#EMPTY#";
        }
        return this.acceptType;
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            return "#EMPTY#";
        }
        return this.contentType;
    }

    @Override
    public String getHttpMethod() {
        if (this.httpMethod == null) {
            return "#EMPTY#";
        }
        return this.httpMethod;
    }

    @Override
    public String getScheme() {
        if (this.scheme == null) {
            return "#EMPTY#";
        }
        return this.scheme;
    }

    @Override
    public String getHost() {
        if (this.host == null) {
            return "#EMPTY#";
        }
        return this.host;
    }

    @Override
    public String getPort() {
        if (this.port == null) {
            return "#EMPTY#";
        }
        return this.port;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            return "#EMPTY#";
        }
        return this.path;
    }

    @Override
    public int getReadTimeout() {
        if (this.readTimeout == 0) {
            return -1;
        }
        return this.readTimeout;
    }

    @Override
    public int getConnectTimeout() {
        if (this.connectTimeout == 0) {
            return -1;
        }
        return this.connectTimeout;
    }

    @Override
    public NestedMappingDescription[] getNestedMapping() {
        if (this.nestedMapping == null) {
            return DEFAULT_NESTED_MAPPING;
        }
        return this.nestedMapping;
    }

    @Override
    public RootMappingDescription[] getRootMapping() {
        if (this.rootMapping == null) {
            return DEFAULT_ROOT_MAPPING;
        }
        return this.rootMapping;
    }
}

