/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttAuthentication;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttSession;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.api.MqttTopic;
import org.eclipse.sensinact.gateway.sthbnd.mqtt.util.listener.MqttConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttBroker {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 1883;
    private static final Protocol DEFAULT_PROTOCOL = Protocol.TCP;
    private static final Logger LOG = LoggerFactory.getLogger(MqttBroker.class);
    private final String clientId = UUID.randomUUID().toString();
    private String host;
    private int port;
    private Protocol protocol;
    private MqttSession session;
    private MqttAuthentication authentication;
    private List<MqttTopic> topics;
    private MqttConnectionHandler handler;
    private MqttClient client;

    private MqttBroker() {
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public MqttSession getSession() {
        return this.session;
    }

    public MqttAuthentication getAuthentication() {
        return this.authentication;
    }

    public void publish(String topic, String message) {
        try {
            LOG.info("Publishing message {} on the topic {}", (Object)message, (Object)topic);
            this.client.publish(topic, message.getBytes(), 1, false);
        }
        catch (Exception e) {
            LOG.error("Unable to publishing message {} on the topic {}", (Object)message, (Object)topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToTopic(MqttTopic topic) {
        List<MqttTopic> list = this.topics;
        synchronized (list) {
            if (this.topics.indexOf(topic) < 0) {
                this.topics.add(topic);
                LOG.info("Subscription to the topic {} added to the list", (Object)topic.getTopic());
                try {
                    if (this.client == null || !this.client.isConnected()) {
                        this.connect();
                    }
                    this.client.subscribe(topic.getTopic(), (IMqttMessageListener)topic.getListener());
                    LOG.info("Subscription to the topic {} done", (Object)topic.getTopic());
                }
                catch (MqttException e) {
                    LOG.error("Error when subscribing to the topic {}", (Object)topic.getTopic(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeFromTopic(MqttTopic topic) {
        try {
            this.client.unsubscribe(topic.getTopic());
            LOG.info("Unsubscription to the topic {} done", (Object)topic.getTopic());
            List<MqttTopic> list = this.topics;
            synchronized (list) {
                this.topics.remove(topic);
                if (this.topics.isEmpty()) {
                    this.disconnect();
                }
            }
        }
        catch (MqttException e) {
            LOG.error("Error when unsubscribing from the topic {}", (Object)topic.getTopic(), (Object)e);
        }
    }

    public List<MqttTopic> getTopics() {
        return this.topics;
    }

    public MqttConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public void connect() throws MqttException {
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
        }
        this.client = null;
        String brokerUrl = String.format("%s://%s:%d", new Object[]{this.protocol, this.host, this.port});
        this.client = new MqttClient(brokerUrl, UUID.randomUUID().toString(), (MqttClientPersistence)new MemoryPersistence());
        if (this.handler == null) {
            LOG.info("Custom Connection Handler not defined, using default reconnection for {}", (Object)brokerUrl);
            this.handler = new MqttConnectionHandlerImpl(this);
        }
        this.client.setCallback((MqttCallback)this.handler);
        this.doConnect();
    }

    public void doConnect() throws MqttException {
        if (this.client == null) {
            throw new MqttException((Throwable)new NullPointerException("Valid client is required"));
        }
        String brokerUrl = String.format("%s://%s:%d", new Object[]{this.protocol, this.host, this.port});
        MqttConnectOptions connectOptions = new MqttConnectOptions();
        if (this.session != null) {
            if (this.session.getCleanSession() != null) {
                connectOptions.setCleanSession(this.session.getCleanSession().booleanValue());
            }
            if (this.session.getAutoReconnect() != null) {
                connectOptions.setAutomaticReconnect(this.session.getAutoReconnect().booleanValue());
            }
            if (this.session.getMaxInFlight() != null) {
                connectOptions.setMaxInflight(this.session.getMaxInFlight().intValue());
            }
        }
        if (this.authentication != null) {
            if (this.authentication.getUsername() != null) {
                connectOptions.setUserName(this.authentication.getUsername());
            }
            if (this.authentication.getPassword() != null) {
                connectOptions.setPassword(this.authentication.getPassword().toCharArray());
            }
            if (this.authentication.getSslProperties() != null) {
                connectOptions.setSSLProperties(this.authentication.getSslProperties());
            }
        }
        LOG.info("Connecting to broker: {}", (Object)brokerUrl);
        try {
            if (!this.client.isConnected()) {
                this.client.connect(connectOptions);
                this.handler.connectionEstablished(this);
            } else {
                LOG.error("Already connected to the MQTT broker: {}", (Object)brokerUrl);
            }
        }
        catch (MqttException e) {
            this.handler.connectionFailed(this);
            LOG.error("Failed to connect to MQTT broker", (Throwable)e);
        }
        LOG.info("Connected to broker: {}:{}", (Object)this.host, (Object)this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws MqttException {
        List<MqttTopic> list = this.topics;
        synchronized (list) {
            if (!this.topics.isEmpty()) {
                Iterator<MqttTopic> it = this.topics.iterator();
                while (it.hasNext()) {
                    MqttTopic topic = null;
                    try {
                        topic = it.next();
                        LOG.info("Unsubscribing from topic {} done", (Object)topic.getTopic());
                        this.client.unsubscribe(topic.getTopic());
                        it.remove();
                        LOG.info("Unsubscription to the topic {} done", (Object)topic.getTopic());
                    }
                    catch (MqttException e) {
                        LOG.error("Unable to unsubscribe from the topic {}", (Object)topic.getTopic());
                    }
                }
            }
        }
        if (this.client != null && this.client.isConnected()) {
            this.client.disconnect();
            LOG.info("Disconnected from MQTT broker: {}", (Object)this.host);
        }
        this.client = null;
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setSession(MqttSession session) {
        this.session = session;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setAuthentication(MqttAuthentication authentication) {
        this.authentication = authentication;
    }

    public void setHandler(MqttConnectionHandler handler) {
        this.handler = handler;
    }

    static /* synthetic */ Protocol access$000() {
        return DEFAULT_PROTOCOL;
    }

    private class MqttConnectionHandlerImpl
    extends MqttConnectionHandler {
        private Timer timer;

        public MqttConnectionHandlerImpl(MqttBroker broker) {
            super(broker);
            this.timer = new Timer();
        }

        @Override
        public void connectionFailed(final MqttBroker broker) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        broker.doConnect();
                    }
                    catch (MqttException e) {
                        LOG.error("Connection Failed with {}://{}:{}", new Object[]{broker.getProtocol().name(), broker.getHost(), broker.getPort()});
                    }
                }
            }, 5000L);
        }

        @Override
        public void connectionEstablished(MqttBroker broker) {
            LOG.debug("Connection with {}://{}:{} established", new Object[]{broker.getProtocol().name(), broker.getHost(), broker.getPort()});
            for (MqttTopic topic : MqttBroker.this.topics) {
                try {
                    LOG.info("Subscription to the topic {} done", (Object)topic.getTopic());
                    broker.getClient().subscribe(topic.getTopic(), (IMqttMessageListener)topic.getListener());
                }
                catch (Exception e) {
                    LOG.error("Unable to subscribe to the topic {}", (Object)topic.getTopic());
                }
            }
        }

        @Override
        public void connectionLost(MqttBroker broker) {
            try {
                broker.connect();
            }
            catch (MqttException e) {
                LOG.debug("Connection Lost with {}://{}:{}", new Object[]{broker.getProtocol().name(), broker.getHost(), broker.getPort()});
            }
        }
    }

    public static class Builder {
        private String host = "127.0.0.1";
        private int port = 1883;
        private Protocol protocol = MqttBroker.access$000();
        private MqttSession session = new MqttSession.Builder().build();
        private MqttAuthentication authentication = new MqttAuthentication.Builder().build();
        private List<MqttTopic> topics = Collections.synchronizedList(new ArrayList());
        private MqttConnectionHandler handler;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder session(MqttSession session) {
            this.session = session;
            return this;
        }

        public Builder authentication(MqttAuthentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder topics(List<MqttTopic> topics) {
            this.topics = topics;
            return this;
        }

        public Builder handler(MqttConnectionHandler handler) {
            this.handler = handler;
            return this;
        }

        public MqttBroker build() {
            MqttBroker broker = new MqttBroker();
            broker.handler = this.handler;
            broker.topics = this.topics;
            broker.authentication = this.authentication;
            broker.host = this.host;
            broker.port = this.port;
            broker.protocol = this.protocol;
            broker.session = this.session;
            broker.authentication = this.authentication;
            broker.topics = this.topics;
            broker.handler = this.handler;
            return broker;
        }
    }

    public static enum Protocol {
        TCP,
        SSL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

