/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.rest.internal.http;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sensinact.gateway.core.security.AccessToken;
import org.eclipse.sensinact.gateway.core.security.Credentials;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SessionToken;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.LoginResponse;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.rest.internal.RestAccessConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet
public class HttpLoginEndpoint
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HttpLoginEndpoint.class);
    private NorthboundMediator mediator;

    public HttpLoginEndpoint(NorthboundMediator mediator) {
        this.mediator = mediator;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doExecute(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doExecute(request, response);
    }

    private final void doExecute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            return;
        }
        try {
            LoginResponse loginResponse = null;
            String tokenHeader = request.getHeader("X-Auth-Token");
            String authorizationHeader = request.getHeader("Authorization");
            if (tokenHeader != null) {
                loginResponse = this.mediator.getAccessingEndpoint().reactivateEndpoint(new SessionToken(tokenHeader));
            } else if (authorizationHeader != null) {
                if (authorizationHeader.startsWith("Basic")) {
                    loginResponse = this.mediator.getAccessingEndpoint().createNorthboundEndpoint(new Credentials(authorizationHeader.substring(6)));
                } else if (authorizationHeader.startsWith("Bearer")) {
                    loginResponse = this.mediator.getAccessingEndpoint().createNorthboundEndpoint(new AccessToken(authorizationHeader.substring(7)));
                }
            }
            byte[] resultBytes = loginResponse.getJSON().getBytes();
            response.setContentType(RestAccessConstants.JSON_CONTENT_TYPE);
            response.setContentLength(resultBytes.length);
            response.setBufferSize(resultBytes.length);
            ServletOutputStream output = response.getOutputStream();
            output.write(resultBytes);
            response.setStatus(200);
        }
        catch (InvalidCredentialException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            response.sendError(403, e.getMessage());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            response.sendError(520, "Internal server error");
        }
    }
}

