/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.core;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.aries.rsa.core.RemoteServiceAdminCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointPermission;
import org.osgi.service.remoteserviceadmin.ExportReference;
import org.osgi.service.remoteserviceadmin.ExportRegistration;
import org.osgi.service.remoteserviceadmin.ImportReference;
import org.osgi.service.remoteserviceadmin.ImportRegistration;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public class RemoteServiceAdminInstance
implements RemoteServiceAdmin {
    private final BundleContext bctx;
    private final RemoteServiceAdminCore rsaCore;
    private boolean closed;

    public RemoteServiceAdminInstance(BundleContext bc, RemoteServiceAdminCore core) {
        this.bctx = bc;
        this.rsaCore = core;
    }

    public List<ExportRegistration> exportService(ServiceReference ref, Map properties) {
        return this.closed ? Collections.emptyList() : this.rsaCore.exportService(ref, properties);
    }

    @Override
    public Collection<ExportReference> getExportedServices() {
        this.checkPermission(new EndpointPermission("*", "read"));
        return this.closed ? null : this.rsaCore.getExportedServices();
    }

    @Override
    public Collection<ImportReference> getImportedEndpoints() {
        this.checkPermission(new EndpointPermission("*", "read"));
        return this.closed ? null : this.rsaCore.getImportedEndpoints();
    }

    @Override
    public ImportRegistration importService(final EndpointDescription endpoint) {
        String frameworkUUID = this.bctx.getProperty("org.osgi.framework.uuid");
        this.checkPermission(new EndpointPermission(endpoint, frameworkUUID, "import"));
        return AccessController.doPrivileged(new PrivilegedAction<ImportRegistration>(){

            @Override
            public ImportRegistration run() {
                return RemoteServiceAdminInstance.this.closed ? null : RemoteServiceAdminInstance.this.rsaCore.importService(endpoint);
            }
        });
    }

    public void close(Bundle bundle, boolean closeAll) {
        this.closed = true;
        this.rsaCore.removeExportRegistrations(bundle);
        if (closeAll) {
            this.rsaCore.close();
        }
    }

    private void checkPermission(EndpointPermission permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(permission);
        }
    }
}

