/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.nthbnd.endpoint;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.sensinact.gateway.core.AnonymousSession;
import org.eclipse.sensinact.gateway.core.Session;
import org.eclipse.sensinact.gateway.core.filtering.FilteringCollection;
import org.eclipse.sensinact.gateway.core.message.AbstractMidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.MidAgentCallback;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaFilter;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponse;
import org.eclipse.sensinact.gateway.core.method.ActResponse;
import org.eclipse.sensinact.gateway.core.method.DescribeResponse;
import org.eclipse.sensinact.gateway.core.method.GetResponse;
import org.eclipse.sensinact.gateway.core.method.SetResponse;
import org.eclipse.sensinact.gateway.core.method.SubscribeResponse;
import org.eclipse.sensinact.gateway.core.method.UnsubscribeResponse;
import org.eclipse.sensinact.gateway.core.security.Authentication;
import org.eclipse.sensinact.gateway.core.security.InvalidCredentialException;
import org.eclipse.sensinact.gateway.core.security.SecuredAccessException;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.Argument;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundMediator;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRecipient;
import org.eclipse.sensinact.gateway.nthbnd.endpoint.NorthboundRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NorthboundEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(NorthboundEndpoint.class);
    private Session session;
    private NorthboundMediator mediator;

    public NorthboundEndpoint(NorthboundMediator mediator, Authentication<?> authentication) throws InvalidCredentialException {
        this.mediator = mediator;
        this.session = this.mediator.getSession(authentication);
        if (this.session == null) {
            throw new NullPointerException("null sensiNact session");
        }
    }

    public String getSessionToken() {
        return this.session.getSessionId();
    }

    public AccessMethodResponse<?> execute(NorthboundRequest request) {
        AccessMethodResponse result = null;
        Argument[] arguments = request.getExecutionArguments();
        String meth = request.getMethod();
        Class[] parameterTypes = Argument.getParameterTypes(arguments);
        Predicate<Method> predicate = m -> {
            if (!m.getName().equals(meth)) {
                return false;
            }
            Class<?>[] types = m.getParameterTypes();
            if (types.length < parameterTypes.length && !m.isVarArgs()) {
                return false;
            }
            if (types.length == parameterTypes.length + 1 && !m.isVarArgs()) {
                return false;
            }
            if (types.length > parameterTypes.length + 1) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                if (i == types.length - 1 && (types.length == parameterTypes.length + 1 || types.length < parameterTypes.length) || types[i].isAssignableFrom(parameterTypes[i])) continue;
                return false;
            }
            return true;
        };
        try {
            Method method;
            Method[] methods = this.getClass().getDeclaredMethods();
            Optional<Method> opt = Arrays.stream(methods).filter(predicate).findFirst();
            Method method2 = method = opt.isPresent() ? opt.get() : null;
            if (method != null) {
                Object[] args = Argument.getParameters(arguments);
                if (method.isVarArgs()) {
                    if (method.getParameterTypes().length == parameterTypes.length + 1) {
                        Object[] _args = new Object[parameterTypes.length + 1];
                        System.arraycopy(args, 0, _args, 0, parameterTypes.length);
                        _args[parameterTypes.length] = null;
                        args = _args;
                    } else if (method.getParameterTypes().length < parameterTypes.length) {
                        Object[] _args = new Object[method.getParameterTypes().length];
                        Object[] _var = new Object[parameterTypes.length - method.getParameterTypes().length + 1];
                        if (method.getParameterTypes().length > 1) {
                            System.arraycopy(args, 0, _args, 0, method.getParameterTypes().length - 1);
                        }
                        int n = 0;
                        for (int i = method.getParameterTypes().length - 1; i < parameterTypes.length; ++i) {
                            _var[n++] = args[i];
                        }
                        _args[method.getParameterTypes().length - 1] = _var;
                        args = _args;
                    }
                }
                result = (AccessMethodResponse)method.invoke((Object)this, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void registerUser(String login, String password, String account, String accountType) throws SecuredAccessException {
        if (!(this.session instanceof AnonymousSession)) {
            throw new SecuredAccessException("Invalid Session");
        }
        ((AnonymousSession)this.session).registerUser(login, password, account, accountType);
    }

    public void renewUserPassword(String account) throws SecuredAccessException {
        if (!(this.session instanceof AnonymousSession)) {
            throw new SecuredAccessException("Invalid Session");
        }
        ((AnonymousSession)this.session).renewPassword(account);
    }

    public SubscribeResponse registerAgent(String requestIdentifier, AbstractMidAgentCallback callback, SnaFilter filter) {
        return this.session.registerSessionAgent(requestIdentifier, (MidAgentCallback)callback, filter);
    }

    public UnsubscribeResponse unregisterAgent(String requestIdentifier, String agentId) {
        return this.session.unregisterSessionAgent(requestIdentifier, agentId);
    }

    public DescribeResponse<String> all(String requestIdentifier) {
        return this.all(requestIdentifier, null, null);
    }

    public DescribeResponse<String> all(String requestIdentifier, String filter) {
        return this.all(requestIdentifier, filter, null);
    }

    public DescribeResponse<String> all(String requestIdentifier, String filter, FilteringCollection filterCollection) {
        return this.session.getAll(requestIdentifier, filter, filterCollection);
    }

    public DescribeResponse<String> serviceProvidersList(String requestIdentifier) {
        return this.serviceProvidersList(requestIdentifier, null);
    }

    public DescribeResponse<String> serviceProvidersList(String requestIdentifier, FilteringCollection filterCollection) {
        return this.session.getProviders(requestIdentifier, filterCollection);
    }

    public DescribeResponse<JSONObject> serviceProviderDescription(String requestIdentifier, String serviceProviderId) {
        return this.session.getProvider(requestIdentifier, serviceProviderId);
    }

    public DescribeResponse<String> servicesList(String requestIdentifier, String serviceProviderId) {
        return this.servicesList(requestIdentifier, serviceProviderId, null);
    }

    public DescribeResponse<String> servicesList(String requestIdentifier, String serviceProviderId, FilteringCollection filterCollection) {
        return this.session.getServices(requestIdentifier, serviceProviderId, filterCollection);
    }

    public DescribeResponse<JSONObject> serviceDescription(String requestIdentifier, String serviceProviderId, String serviceId) {
        return this.session.getService(requestIdentifier, serviceProviderId, serviceId);
    }

    public DescribeResponse<String> resourcesList(String requestIdentifier, String serviceProviderId, String serviceId) {
        return this.resourcesList(requestIdentifier, serviceProviderId, serviceId, null);
    }

    public DescribeResponse<String> resourcesList(String requestIdentifier, String serviceProviderId, String serviceId, FilteringCollection filterCollection) {
        return this.session.getResources(requestIdentifier, serviceProviderId, serviceId, filterCollection);
    }

    public DescribeResponse<JSONObject> resourceDescription(String requestIdentifier, String serviceProviderId, String serviceId, String resourceId) {
        return this.session.getResource(requestIdentifier, serviceProviderId, serviceId, resourceId);
    }

    public GetResponse get(String requestIdentifier, String serviceProviderId, String serviceId, String resourceId, String attributeId, Object ... args) {
        return this.session.get(requestIdentifier, serviceProviderId, serviceId, resourceId, attributeId, args);
    }

    public SetResponse set(String requestIdentifier, String serviceProviderId, String serviceId, String resourceId, String attributeId, Object value, Object ... args) {
        return this.session.set(requestIdentifier, serviceProviderId, serviceId, resourceId, attributeId, value, args);
    }

    public ActResponse act(String requestIdentifier, String serviceProviderId, String serviceId, String resourceId, Object[] arguments) {
        return this.session.act(requestIdentifier, serviceProviderId, serviceId, resourceId, arguments);
    }

    public SubscribeResponse subscribe(String requestIdentifier, String serviceProviderId, String serviceId, String resourceId, String attributeId, NorthboundRecipient recipient, JSONArray conditions, String policy, Object ... args) {
        return this.session.subscribe(requestIdentifier, serviceProviderId, serviceId, resourceId, (Recipient)recipient, conditions, policy, args);
    }

    public UnsubscribeResponse unsubscribe(String requestIdentifier, String serviceProviderId, String serviceId, String resourceId, String attributeId, String subscriptionId, Object ... args) {
        return this.session.unsubscribe(requestIdentifier, serviceProviderId, serviceId, resourceId, subscriptionId, args);
    }
}

