/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.historic.storage.manager;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.annotation.TaskCommand;
import org.eclipse.sensinact.gateway.generic.annotation.TaskExecution;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.HistoricProvider;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.HistoricValueRequest;
import org.eclipse.sensinact.gateway.historic.storage.reader.api.TemporalDTO;
import org.json.JSONArray;
import org.json.JSONObject;

@TaskExecution
public class HistoricValueQuery {
    private Mediator mediator;

    public HistoricValueQuery(Mediator mediator) {
        this.mediator = mediator;
    }

    private ZonedDateTime parseTime(String time) {
        try {
            long longTime = Long.parseLong(time);
            return Instant.ofEpochMilli(longTime).atOffset(ZoneOffset.UTC).toZonedDateTime();
        }
        catch (NumberFormatException nfe) {
            return ZonedDateTime.parse(time);
        }
    }

    @TaskCommand(method=Task.CommandType.GET, target="/historicManager/history/single")
    public String get(String path, String[] paths, String time) {
        try {
            ZonedDateTime t = this.parseTime(time);
            HistoricValueRequest request = (HistoricValueRequest)this.mediator.callService(HistoricProvider.class, HistoricProvider::newValueRequest);
            if (request == null) {
                return null;
            }
            request.setHistoricTime(t);
            Arrays.stream(paths).map(s -> s.split("/")).forEach(s -> request.addTargetResource(s[0], s[1], s[2]));
            Map data = request.execute();
            JSONArray array = new JSONArray();
            for (Map.Entry e : data.entrySet()) {
                JSONObject container = new JSONObject();
                JSONObject value = new JSONObject();
                container.put("path", e.getKey());
                container.put("historicValue", (Object)value);
                TemporalDTO dto = (TemporalDTO)e.getValue();
                value.put("tagId", dto.tagID);
                value.put("timestamp", dto.timestamp);
                value.put("value", (Object)dto.value);
                array.put((Object)container);
            }
            return array.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

