/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.security.AccessLevelOption;
import org.eclipse.sensinact.gateway.core.security.MethodAccessibility;

public interface SensiNactResourceModelConfiguration {
    public Class<? extends ServiceProviderImpl> getProviderImplementationType();

    public Class<? extends ServiceImpl> getServiceImplementationType();

    public Class<? extends ResourceImpl> getResourceImplementationType();

    public byte getResourceBuildPolicy();

    public byte getServiceBuildPolicy();

    public boolean getStartAtInitializationTime();

    public SensiNactResourceModelConfiguration setProviderImplementationType(Class<? extends ServiceProviderImpl> var1);

    public SensiNactResourceModelConfiguration setServiceImplmentationType(Class<? extends ServiceImpl> var1);

    public SensiNactResourceModelConfiguration setResourceImplementationType(Class<? extends ResourceImpl> var1);

    public SensiNactResourceModelConfiguration setDefaultResourceType(Class<? extends Resource> var1);

    public SensiNactResourceModelConfiguration setDefaultDataType(Class<?> var1);

    public SensiNactResourceModelConfiguration setDefaultModifiable(Modifiable var1);

    public SensiNactResourceModelConfiguration setDefaultUpdatePolicy(Resource.UpdatePolicy var1);

    public SensiNactResourceModelConfiguration setResourceBuildPolicy(byte var1);

    public SensiNactResourceModelConfiguration setServiceBuildPolicy(byte var1);

    public SensiNactResourceModelConfiguration setStartAtInitializationTime(boolean var1);

    public List<MethodAccessibility> getAccessibleMethods(String var1, AccessLevelOption var2);

    public AccessLevelOption getAuthenticatedAccessLevelOption(String var1, String var2);

    public static enum BuildPolicy {
        BUILD_ON_DESCRIPTION(4),
        BUILD_COMPLETE_ON_DESCRIPTION(5),
        BUILD_APPEARING_ON_DESCRIPTION(6),
        BUILD_NON_DESCRIBED(8);

        private final byte policy;

        private BuildPolicy(byte policy) {
            this.policy = policy;
        }

        public byte getPolicy() {
            return this.policy;
        }

        public static BuildPolicy[] valueOf(byte policy) {
            int length;
            ArrayList<BuildPolicy> policies = new ArrayList<BuildPolicy>();
            BuildPolicy[] values = BuildPolicy.values();
            int n = length = values == null ? 0 : values.length;
            for (int index = 0; index < length; ++index) {
                if (!BuildPolicy.isBuildPolicy(policy, values[index])) continue;
                policies.add(values[index]);
            }
            return policies.toArray(new BuildPolicy[0]);
        }

        public static boolean isBuildPolicy(byte policy, BuildPolicy buildPolicy) {
            return (buildPolicy.getPolicy() & policy) == buildPolicy.getPolicy();
        }
    }
}

