/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.message;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.execution.ErrorHandler;
import org.eclipse.sensinact.gateway.core.message.BufferMidCallback;
import org.eclipse.sensinact.gateway.core.message.Recipient;
import org.eclipse.sensinact.gateway.core.message.SnaMessage;

public class ScheduledBufferMidCallback
extends BufferMidCallback {
    protected final int delay;
    private Timer timer;

    public ScheduledBufferMidCallback(Mediator mediator, ErrorHandler errorHandler, Recipient recipient, long timeout, int delay, int bufferSize) {
        super(mediator, errorHandler, recipient, timeout, bufferSize);
        this.delay = delay < 10000 ? 10000 : delay;
    }

    public void start() {
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SnaMessage[] snaMessageArray = ScheduledBufferMidCallback.this.buffer;
                synchronized (ScheduledBufferMidCallback.this.buffer) {
                    int length = ScheduledBufferMidCallback.this.length;
                    if (length > 0) {
                        SnaMessage[] buffer = new SnaMessage[length];
                        for (int index = 0; index < length; ++index) {
                            buffer[index] = ScheduledBufferMidCallback.this.buffer[index];
                        }
                        try {
                            ScheduledBufferMidCallback.this.recipient.callback(ScheduledBufferMidCallback.this.getName(), buffer);
                        }
                        catch (Exception e) {
                            int continuation = ScheduledBufferMidCallback.this.getCallbackErrorHandler().handle(e);
                            switch (continuation) {
                                case 1: 
                                case 256: 
                                case 4096: {
                                    break;
                                }
                                case 16: {
                                    ScheduledBufferMidCallback.this.stop();
                                }
                            }
                        }
                        ScheduledBufferMidCallback.this.length = 0;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(task, 0L, (long)this.delay);
    }

    @Override
    public void stop() {
        super.stop();
        this.timer.cancel();
        this.timer.purge();
        this.timer = null;
    }
}

