/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.core.method;

import java.lang.reflect.Method;
import org.eclipse.sensinact.gateway.core.method.AbstractAccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.InvalidReflectiveExecutorException;
import org.json.JSONObject;

public class ReflectionAccessMethodExecutor
extends AbstractAccessMethodExecutor {
    private final Method method;
    private Object target;

    public ReflectionAccessMethodExecutor(Object target, Method method) throws InvalidReflectiveExecutorException {
        if (!method.getDeclaringClass().isAssignableFrom(target.getClass())) {
            throw new InvalidReflectiveExecutorException("Incompatible method and target types");
        }
        if (!JSONObject.class.isAssignableFrom((Class)method.getGenericReturnType()) && !Void.class.isAssignableFrom((Class)method.getGenericReturnType())) {
            throw new InvalidReflectiveExecutorException("Incompatible returned type : JSONObject or Void expected");
        }
        this.method = method;
        this.target = target;
    }

    protected void doExecute(AccessMethodResponseBuilder responseBuilder) throws Exception {
        Object result = this.method.invoke(this.target, responseBuilder.getParameters());
        if (result != null && responseBuilder.getComponentType().isAssignableFrom(result.getClass())) {
            responseBuilder.push(result);
        }
    }
}

