/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.provider.fastbin.tcp;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.rsa.provider.fastbin.tcp.TcpTransport;
import org.apache.aries.rsa.provider.fastbin.tcp.TcpTransportServer;
import org.apache.aries.rsa.provider.fastbin.util.IntrospectionSupport;
import org.apache.aries.rsa.provider.fastbin.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportFactory.class);

    public TcpTransportServer bind(String location) throws Exception {
        URI uri = new URI(location);
        TcpTransportServer server = this.createTcpTransportServer(uri);
        if (server == null) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(uri));
        IntrospectionSupport.setProperties(server, options);
        Map<String, Object> transportOptions = IntrospectionSupport.extractProperties(options, "transport.");
        server.setTransportOption(transportOptions);
        return server;
    }

    public TcpTransport connect(String location) throws Exception {
        URI uri = new URI(location);
        TcpTransport transport = this.createTransport(uri);
        if (transport == null) {
            return null;
        }
        HashMap<String, String> options = new HashMap<String, String>(URISupport.parseParameters(uri));
        URI localLocation = this.getLocalLocation(uri);
        transport.connecting(uri, localLocation);
        Map<String, Object> socketOptions = IntrospectionSupport.extractProperties(options, "socket.");
        transport.setSocketOptions(socketOptions);
        IntrospectionSupport.setProperties(transport, options);
        if (!options.isEmpty()) {
            try {
                transport.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new IllegalArgumentException("Invalid connect parameters: " + options);
        }
        return transport;
    }

    protected TcpTransportServer createTcpTransportServer(URI location) throws IOException, URISyntaxException, Exception {
        if (!location.getScheme().equals("tcp")) {
            return null;
        }
        return new TcpTransportServer(location);
    }

    protected TcpTransport createTransport(URI uri) throws NoSuchAlgorithmException, Exception {
        if (!uri.getScheme().equals("tcp")) {
            return null;
        }
        TcpTransport transport = new TcpTransport();
        return transport;
    }

    protected URI getLocalLocation(URI location) {
        URI localLocation = null;
        String path = location.getPath();
        if (path != null && path.length() > 0) {
            int localPortIndex = path.indexOf(58);
            try {
                Integer.parseInt(path.substring(localPortIndex + 1));
                String localString = location.getScheme() + ":/" + path;
                localLocation = new URI(localString);
            }
            catch (Exception e) {
                LOG.warn("path isn't a valid local location for TcpTransport to use", (Throwable)e);
            }
        }
        return localLocation;
    }

    protected String getOption(Map options, String key, String def) {
        String rc = (String)options.remove(key);
        if (rc == null) {
            rc = def;
        }
        return rc;
    }
}

