/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.rsa.discovery.zookeeper;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.aries.rsa.discovery.zookeeper.ZooKeeperDiscovery;
import org.apache.aries.rsa.discovery.zookeeper.server.ZookeeperStarter;
import org.apache.zookeeper.server.ZooTrace;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;

public class Activator
implements BundleActivator {
    private static final String PID_DISCOVERY_ZOOKEEPER = "org.apache.aries.rsa.discovery.zookeeper";
    private static final String PID_ZOOKEEPER_SERVER = "org.apache.aries.rsa.discovery.zookeeper.server";
    private ZooKeeperDiscovery zkd;
    private ZookeeperStarter zkStarter;

    public synchronized void start(BundleContext bc) throws Exception {
        this.zkd = new ZooKeeperDiscovery(bc);
        bc.registerService(ManagedService.class, (Object)this.zkd, this.configProperties(PID_DISCOVERY_ZOOKEEPER));
        this.zkStarter = new ZookeeperStarter(bc);
        bc.registerService(ManagedService.class, (Object)this.zkStarter, this.configProperties(PID_ZOOKEEPER_SERVER));
    }

    public synchronized void stop(BundleContext bc) throws Exception {
        ZooTrace.getTextTraceLevel();
        this.zkd.stop(true);
        if (this.zkStarter != null) {
            this.zkStarter.shutdown();
        }
    }

    private Dictionary<String, String> configProperties(String pid) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", pid);
        return props;
    }
}

