/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.util.Collection;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.common.primitive.Modifiable;
import org.eclipse.sensinact.gateway.core.ModelConfigurationBuilder;
import org.eclipse.sensinact.gateway.core.Resource;
import org.eclipse.sensinact.gateway.core.ResourceConfigBuilder;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.SensiNactResourceModelConfiguration;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.ServiceProviderImpl;
import org.eclipse.sensinact.gateway.core.security.AccessLevel;
import org.eclipse.sensinact.gateway.core.security.AccessTree;
import org.eclipse.sensinact.gateway.generic.Connector;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.ExtModelInstance;
import org.eclipse.sensinact.gateway.generic.ExtResourceImpl;
import org.eclipse.sensinact.gateway.generic.ExtServiceImpl;
import org.eclipse.sensinact.gateway.generic.ExtServiceProviderImpl;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.util.ReflectUtils;

public class ExtModelConfigurationBuilder<P extends Packet, C extends ExtModelConfiguration<P>, I extends ExtModelInstance<C>>
extends ModelConfigurationBuilder<C, I> {
    protected Boolean lockedAtInitializationTime;
    protected Boolean isDesynchronized;
    private Class<P> packetType;
    private Class<? extends Connector<P>> connectorType;

    public static <PACKET extends Packet> ExtModelConfigurationBuilder<PACKET, ExtModelConfiguration<PACKET>, ExtModelInstance<ExtModelConfiguration<PACKET>>> instance(Mediator mediator, Class<PACKET> packetType) {
        return new ExtModelConfigurationBuilder<PACKET, ExtModelConfiguration, ExtModelInstance>(mediator, ExtModelConfiguration.class, ExtModelInstance.class, packetType);
    }

    public static ExtModelConfigurationBuilder<Packet, ExtModelConfiguration<Packet>, ExtModelInstance<ExtModelConfiguration<Packet>>> instance(Mediator mediator) {
        return ExtModelConfigurationBuilder.instance(mediator, Packet.class);
    }

    public ExtModelConfigurationBuilder(Mediator mediator, Class<C> resourceModelConfigurationType, Class<I> resourceModelInstanceType, Class<P> packetType) {
        super(mediator, resourceModelConfigurationType, resourceModelInstanceType);
        this.packetType = packetType;
        super.withProviderImplementationType(ExtServiceProviderImpl.class);
        super.withServiceImplementationType(ExtServiceImpl.class);
        super.withResourceImplementationType(ExtResourceImpl.class);
        super.withServiceBuildPolicy((byte)(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_APPEARING_ON_DESCRIPTION.getPolicy() | SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy()));
        super.withResourceBuildPolicy(SensiNactResourceModelConfiguration.BuildPolicy.BUILD_COMPLETE_ON_DESCRIPTION.getPolicy());
    }

    public ExtModelConfigurationBuilder<P, C, I> withProviderImplementationType(Class<? extends ServiceProviderImpl> serviceProviderType) {
        super.withProviderImplementationType(serviceProviderType);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withServiceImplementationType(Class<? extends ServiceImpl> serviceType) {
        super.withServiceImplementationType(serviceType);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withUser(String userPublicKey, AccessLevel accessLevel) {
        super.withUser(userPublicKey, accessLevel);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withResourceImplementationType(Class<? extends ResourceImpl> resourceType) {
        super.withResourceImplementationType(resourceType);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withDefaultResourceType(Class<? extends Resource> defaultResourceType) {
        super.withDefaultResourceType(defaultResourceType);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withDefaultDataType(Class<?> defaultDataType) {
        super.withDefaultDataType(defaultDataType);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withDefaultModifiable(Modifiable defaultModifiable) {
        super.withDefaultModifiable(defaultModifiable);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withDefaultUpdatePolicy(Resource.UpdatePolicy defaultUpdatePolicy) {
        super.withDefaultUpdatePolicy(defaultUpdatePolicy);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withServiceBuildPolicy(byte buildPolicy) {
        super.withServiceBuildPolicy(buildPolicy);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withResourceBuildPolicy(byte buildPolicy) {
        super.withResourceBuildPolicy(buildPolicy);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withDefaultResourceConfigBuilder(ResourceConfigBuilder defaultResourceConfigBuilder) {
        super.withDefaultResourceConfigBuilder(defaultResourceConfigBuilder);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withStartAtInitializationTime(boolean startAtInitializationTime) {
        super.withStartAtInitializationTime(startAtInitializationTime);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withLockedAtInitializationTime(Boolean lockedAtInitializationTime) {
        this.lockedAtInitializationTime = lockedAtInitializationTime;
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withConnectorType(Class<? extends Connector<P>> connectorType) {
        this.connectorType = connectorType;
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withDesynchronization(Boolean isDesynchronized) {
        this.isDesynchronized = isDesynchronized;
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withObserved(String observed) {
        super.withObserved(observed);
        return this;
    }

    public ExtModelConfigurationBuilder<P, C, I> withObserved(Collection<String> observed) {
        super.withObserved(observed);
        return this;
    }

    protected void configure(C configuration) {
        if (configuration == null) {
            return;
        }
        super.configure(configuration);
        if (this.isDesynchronized != null) {
            ((ExtModelConfiguration)((Object)configuration)).setDesynchronized(this.isDesynchronized);
        }
        if (this.lockedAtInitializationTime != null) {
            ((ExtModelConfiguration)((Object)configuration)).setLockedAtInitializationTime(this.lockedAtInitializationTime);
        }
        if (this.connectorType != null) {
            ((ExtModelConfiguration)((Object)configuration)).setConnectorType(this.connectorType);
        }
    }

    public C build(Object ... parameters) {
        ExtModelConfiguration configuration = null;
        AccessTree accessTree = super.buildAccessTree();
        int parametersLength = parameters == null ? 0 : parameters.length;
        int offset = this.defaultResourceConfigBuilder != null ? 4 : 3;
        Object[] arguments = new Object[parametersLength + offset];
        if (parametersLength > 0) {
            System.arraycopy(parameters, 0, arguments, offset, parametersLength);
        }
        arguments[0] = this.mediator;
        arguments[1] = accessTree;
        arguments[2] = this.packetType;
        if (this.defaultResourceConfigBuilder != null) {
            arguments[3] = this.defaultResourceConfigBuilder;
        }
        configuration = (ExtModelConfiguration)((Object)ReflectUtils.getInstance(ExtModelConfiguration.class, (Class)this.modelConfigurationType, (Object[])arguments));
        this.configure((C)((Object)configuration));
        return (C)((Object)configuration);
    }
}

