/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.primitive.InvalidValueException;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.core.ResourceImpl;
import org.eclipse.sensinact.gateway.core.ServiceImpl;
import org.eclipse.sensinact.gateway.core.method.AbstractAccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethod;
import org.eclipse.sensinact.gateway.core.method.AccessMethodExecutor;
import org.eclipse.sensinact.gateway.core.method.AccessMethodResponseBuilder;
import org.eclipse.sensinact.gateway.core.method.Signature;
import org.eclipse.sensinact.gateway.generic.ExtModelInstance;
import org.eclipse.sensinact.gateway.generic.ExtResourceConfig;
import org.eclipse.sensinact.gateway.generic.ExtServiceImpl;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.annotation.Act;
import org.eclipse.sensinact.gateway.generic.annotation.Get;
import org.eclipse.sensinact.gateway.generic.annotation.Set;
import org.eclipse.sensinact.gateway.generic.annotation.Subscribe;
import org.eclipse.sensinact.gateway.generic.annotation.Unsubscribe;
import org.eclipse.sensinact.gateway.generic.parser.MethodDefinition;
import org.eclipse.sensinact.gateway.generic.parser.SignatureDefinition;
import org.eclipse.sensinact.gateway.util.ReflectUtils;
import org.json.JSONObject;

public class ExtResourceImpl
extends ResourceImpl {
    protected ExtResourceImpl(ExtModelInstance<?> modelInstance, ExtResourceConfig resourceConfig, ExtServiceImpl service) {
        super(modelInstance, (ResourceConfig)resourceConfig, (ServiceImpl)service);
    }

    protected JSONObject passOn(String type, String uri, Object[] parameters) throws Exception {
        Task task = (Task)super.passOn(type, uri, parameters);
        if (type.equals(AccessMethod.GET) && task != null && task.isResultAvailable() && task.getResult() != AccessMethod.EMPTY) {
            super.getAttribute(this.defaultAttribute).setValue(task.getResult(), task.getTimestamp());
        }
        if (task == null) {
            return null;
        }
        return new JSONObject(task.getJSON());
    }

    private Class<? extends Annotation> annotationFromAccessMethodType(String type) {
        switch (type) {
            case "ACT": {
                return Act.class;
            }
            case "DESCRIBE": {
                break;
            }
            case "GET": {
                return Get.class;
            }
            case "SET": {
                return Set.class;
            }
            case "SUBSCRIBE": {
                return Subscribe.class;
            }
            case "UNSUBSCRIBE": {
                return Unsubscribe.class;
            }
        }
        return null;
    }

    protected void buildMethod(ExtResourceConfig resourceConfig, ExtServiceImpl service) {
        if (resourceConfig == null) {
            return;
        }
        for (MethodDefinition methodDefinition : resourceConfig) {
            if (methodDefinition == null) continue;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            final ExtResourceImpl self = this;
            AbstractAccessMethod method = (AbstractAccessMethod)super.getAccessMethod(methodDefinition.getType());
            SignatureDefinition definition2 = null;
            for (SignatureDefinition definition2 : methodDefinition) {
                Method javaMethod;
                Signature signature;
                try {
                    signature = definition2.getSignature(this.modelInstance.mediator(), this, service);
                }
                catch (InvalidValueException e) {
                    continue;
                }
                Class[] parameterTypes = signature.getParameterTypes();
                Class<? extends Annotation> annotationClass = this.annotationFromAccessMethodType(method.getType().name());
                if (annotationClass == null) continue;
                Map methods = ReflectUtils.getAnnotatedMethods(clazz, annotationClass);
                java.util.Set methodSet = methods.keySet();
                final Method reflectionMethod = javaMethod = ReflectUtils.getDeclaredMethod((Method[])methodSet.toArray(new Method[0]), JSONObject.class, null, (Class[])parameterTypes, (boolean)true);
                AccessMethodExecutor executor = null;
                if (reflectionMethod != null) {
                    executor = new AccessMethodExecutor(){

                        public Void execute(AccessMethodResponseBuilder parameter) throws Exception {
                            JSONObject jsonObject = (JSONObject)reflectionMethod.invoke((Object)self, parameter.getParameters());
                            if (!JSONObject.NULL.equals(jsonObject)) {
                                parameter.setAccessMethodObjectResult((Object)jsonObject);
                            }
                            return null;
                        }
                    };
                }
                method.addSignature(signature, executor, AccessMethodExecutor.ExecutionPolicy.AFTER);
                service.buildTriggers(this.getName(), signature, definition2.getReferenceDefinitions());
            }
        }
    }
}

