/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.parser.CommandDefinition;

public class Commands {
    final Map<Task.CommandType, byte[]> commands;

    public Commands(List<CommandDefinition> commands) {
        HashMap<Task.CommandType, byte[]> preCommands = new HashMap<Task.CommandType, byte[]>();
        if (commands != null) {
            for (CommandDefinition commandDefinition : commands) {
                preCommands.put(commandDefinition.getCommandType(), commandDefinition.getIdentifier());
            }
        }
        this.commands = Collections.unmodifiableMap(preCommands);
    }

    protected Commands(Map<Task.CommandType, byte[]> commands) {
        this.commands = Collections.unmodifiableMap(commands);
    }

    public byte[] getCommand(Task.CommandType command) {
        return this.commands.get((Object)command);
    }

    public Task.CommandType getCommand(byte[] command) {
        Task.CommandType commandType2 = null;
        for (Task.CommandType commandType2 : this.commands.keySet()) {
            if (ExtModelConfiguration.compareBytesArrays(this.commands.get((Object)commandType2), command)) break;
            commandType2 = null;
        }
        return commandType2;
    }
}

