/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.security.signature.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.security.signature.internal.CryptographicUtils;
import org.eclipse.sensinact.gateway.security.signature.internal.ManifestChecker;
import org.eclipse.sensinact.gateway.security.signature.internal.SignatureFile;
import org.eclipse.sensinact.gateway.security.signature.internal.SignedBundle;

public class SignatureFileChecker {
    private SignatureFileChecker() {
    }

    private static boolean checkAbsenceOfModification(SignedBundle signedJar, SignatureFile pretendedSigFile) throws IOException {
        Set<String> sigEntries = pretendedSigFile.getEntries().keySet();
        Set<String> mfEntries = signedJar.getManifest().getEntries().keySet();
        boolean noAddition = false;
        boolean noRemoval = false;
        if (sigEntries.containsAll(mfEntries)) {
            noRemoval = true;
        }
        if (mfEntries.containsAll(sigEntries)) {
            noAddition = true;
        }
        return noAddition && noRemoval;
    }

    private static boolean checkHashValuesValid(Mediator mediator, SignedBundle signedBundle, SignatureFile pretendedSigFile, CryptographicUtils cryptoUtils) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        boolean manifestEntriesValid = true;
        Attributes pretendedMainAttributes = pretendedSigFile.getMainAttributes();
        Map<String, Attributes> pretendedEntries = pretendedSigFile.getEntries();
        Map<String, String> dataMap = ManifestChecker.extractEntryHashes(mediator, signedBundle.getEntry("/META-INF/MANIFEST.MF").openStream(), cryptoUtils, pretendedSigFile.getHashAlgo());
        Iterator<Map.Entry<String, String>> iter = dataMap.entrySet().iterator();
        while (iter.hasNext() && manifestEntriesValid) {
            Map.Entry<String, String> entry = iter.next();
            String entryName = entry.getKey();
            String currentHash = entry.getValue();
            String pretendedHash = "SHA1-Digest-Manifest-Main-Attributes".equals(entryName) ? pretendedMainAttributes.getValue(entryName) : ("SHA-256-Digest-Manifest-Main-Attributes".equals(entryName) ? pretendedMainAttributes.getValue(entryName) : ManifestChecker.getEntryHash(pretendedEntries.get(entryName)));
            if (pretendedHash == null) {
                manifestEntriesValid = false;
                continue;
            }
            boolean currentEntryValid = pretendedHash.equals(currentHash);
            manifestEntriesValid &= currentEntryValid;
        }
        return manifestEntriesValid;
    }

    protected static boolean checkEntriesValidity(Mediator mediator, SignedBundle signedJar, SignatureFile pretendedSigFile, CryptographicUtils cryptoUtils) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        boolean absenceOfModifications = SignatureFileChecker.checkAbsenceOfModification(signedJar, pretendedSigFile);
        boolean hashesValid = SignatureFileChecker.checkHashValuesValid(mediator, signedJar, pretendedSigFile, cryptoUtils);
        return absenceOfModifications && hashesValid;
    }
}

