/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.app.basic.installer;

import org.eclipse.sensinact.gateway.app.api.function.AbstractFunction;
import org.eclipse.sensinact.gateway.app.api.plugin.AbstractPlugin;
import org.eclipse.sensinact.gateway.app.api.plugin.PluginInstaller;
import org.eclipse.sensinact.gateway.app.basic.logic.BetweenFunction;
import org.eclipse.sensinact.gateway.app.basic.logic.DoubleConditionFunction;
import org.eclipse.sensinact.gateway.app.basic.logic.SimpleConditionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.AdditionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.AssignmentFunction;
import org.eclipse.sensinact.gateway.app.basic.math.DivisionFunction;
import org.eclipse.sensinact.gateway.app.basic.math.MathFunction;
import org.eclipse.sensinact.gateway.app.basic.math.ModuloFunction;
import org.eclipse.sensinact.gateway.app.basic.math.MultiplicationFunction;
import org.eclipse.sensinact.gateway.app.basic.math.SubtractionFunction;
import org.eclipse.sensinact.gateway.app.basic.sna.ActActionFunction;
import org.eclipse.sensinact.gateway.app.basic.sna.ActionFunction;
import org.eclipse.sensinact.gateway.app.basic.sna.SetActionFunction;
import org.eclipse.sensinact.gateway.app.basic.string.ConcatenateFunction;
import org.eclipse.sensinact.gateway.app.basic.string.StringFunction;
import org.eclipse.sensinact.gateway.app.basic.string.SubstringFunction;
import org.eclipse.sensinact.gateway.app.basic.time.SleepFunction;
import org.eclipse.sensinact.gateway.app.basic.time.TimeFunction;
import org.eclipse.sensinact.gateway.app.manager.json.AppFunction;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.json.JSONObject;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PluginInstaller.class}, property={"plugin.name=BasicPlugin"})
public class BasicInstaller
extends AbstractPlugin {
    protected Mediator mediator;

    @Activate
    public void activate(ComponentContext context) {
        this.mediator = new Mediator(context.getBundleContext());
    }

    public JSONObject getComponentJSONSchema(String function) {
        if (function.equals("lesserThan") || function.equals("lesserEqual") || function.equals("greaterThan") || function.equals("greaterEqual") || function.equals("equal") || function.equals("diff") || function.equals("regex") || function.equals("abs") || function.equals("delta")) {
            return SimpleConditionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (function.equals("and") || function.equals("or")) {
            return DoubleConditionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (function.equals("in")) {
            return BetweenFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (MathFunction.MathOperator.ADDITION.getOperator().equalsIgnoreCase(function)) {
            return AdditionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (MathFunction.MathOperator.SUBTRACTION.getOperator().equalsIgnoreCase(function)) {
            return SubtractionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (MathFunction.MathOperator.MULTIPLICATION.getOperator().equalsIgnoreCase(function)) {
            return MultiplicationFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (MathFunction.MathOperator.DIVISION.getOperator().equalsIgnoreCase(function)) {
            return DivisionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (MathFunction.MathOperator.MODULO.getOperator().equalsIgnoreCase(function)) {
            return ModuloFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (MathFunction.MathOperator.ASSIGNMENT.getOperator().equalsIgnoreCase(function)) {
            return AssignmentFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (ActionFunction.SnaOperator.ACT.getOperator().equalsIgnoreCase(function)) {
            return ActActionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (ActionFunction.SnaOperator.SET.getOperator().equalsIgnoreCase(function)) {
            return SetActionFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (StringFunction.StringOperator.CONCATENATE.getOperator().equalsIgnoreCase(function)) {
            return ConcatenateFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (StringFunction.StringOperator.SUBSTRING.getOperator().equalsIgnoreCase(function)) {
            return SubstringFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        if (TimeFunction.TimeOperator.SLEEP.getOperator().equalsIgnoreCase(function)) {
            return SleepFunction.getJSONSchemaFunction(this.mediator.getContext());
        }
        return null;
    }

    public AbstractFunction<?> getFunction(AppFunction function) {
        String functionName = function.getName();
        if (functionName.equals("lesserThan") || functionName.equals("lesserEqual") || functionName.equals("greaterThan") || functionName.equals("greaterEqual") || functionName.equals("equal") || functionName.equals("diff") || functionName.equals("regex") || functionName.equals("abs") || functionName.equals("delta")) {
            return new SimpleConditionFunction(this.mediator.getClassLoader(), functionName);
        }
        if (functionName.equals("and") || functionName.equals("or")) {
            return new DoubleConditionFunction(functionName);
        }
        if (functionName.equals("in")) {
            return new BetweenFunction();
        }
        if (MathFunction.MathOperator.ADDITION.getOperator().equalsIgnoreCase(functionName)) {
            return new AdditionFunction();
        }
        if (MathFunction.MathOperator.SUBTRACTION.getOperator().equalsIgnoreCase(functionName)) {
            return new SubtractionFunction();
        }
        if (MathFunction.MathOperator.MULTIPLICATION.getOperator().equalsIgnoreCase(functionName)) {
            return new MultiplicationFunction();
        }
        if (MathFunction.MathOperator.DIVISION.getOperator().equalsIgnoreCase(functionName)) {
            return new DivisionFunction();
        }
        if (MathFunction.MathOperator.MODULO.getOperator().equalsIgnoreCase(functionName)) {
            return new ModuloFunction();
        }
        if (MathFunction.MathOperator.ASSIGNMENT.getOperator().equalsIgnoreCase(functionName)) {
            return new AssignmentFunction();
        }
        if (ActionFunction.SnaOperator.ACT.getOperator().equalsIgnoreCase(functionName)) {
            return new ActActionFunction();
        }
        if (ActionFunction.SnaOperator.SET.getOperator().equalsIgnoreCase(functionName)) {
            return new SetActionFunction();
        }
        if (StringFunction.StringOperator.CONCATENATE.getOperator().equalsIgnoreCase(functionName)) {
            return new ConcatenateFunction();
        }
        if (StringFunction.StringOperator.SUBSTRING.getOperator().equalsIgnoreCase(functionName)) {
            return new SubstringFunction();
        }
        if (TimeFunction.TimeOperator.SLEEP.getOperator().equalsIgnoreCase(functionName)) {
            return new SleepFunction();
        }
        return null;
    }
}

