/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.generic.DefaultConnectorCustomizer;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.packet.PacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.config.HttpMappingProtocolStackEndpointDescription;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.AbstractHttpDevicePacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.CsvPacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint.JsonPacketReader;
import org.eclipse.sensinact.gateway.sthbnd.http.factory.packet.TaskAwareHttpResponsePacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMappingProtocolStackConnectorCustomizer
extends DefaultConnectorCustomizer<TaskAwareHttpResponsePacket> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMappingProtocolStackConnectorCustomizer.class);
    private final SimpleDateFormat timestampFormat;
    private final String serviceProviderIdPattern;
    private final String overrideResponseContentType;
    private final char csvDelimiterChar;
    private final boolean csvTitles;
    private final String csvNumberLocale;
    private final Integer csvMaxLines;
    private final MappingJsonFactory factory;

    public HttpMappingProtocolStackConnectorCustomizer(Mediator mediator, ExtModelConfiguration ExtModelConfiguration2, HttpMappingProtocolStackEndpointDescription config) {
        super(mediator, ExtModelConfiguration2);
        this.timestampFormat = config.getTimestampPattern() == null ? null : new SimpleDateFormat(config.getTimestampPattern());
        this.serviceProviderIdPattern = config.getServiceProviderIdPattern();
        this.overrideResponseContentType = config.getOverrideResponseContentType();
        this.csvDelimiterChar = config.getCsvDelimiter();
        this.csvNumberLocale = config.getCsvNumberLocale();
        this.csvTitles = config.getCsvTitles();
        this.csvMaxLines = config.getCsvMaxRows();
        JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().configure(StreamReadFeature.AUTO_CLOSE_SOURCE, true)).build();
        this.factory = new MappingJsonFactory(jsonFactory, new ObjectMapper(jsonFactory));
    }

    public PacketReader<TaskAwareHttpResponsePacket> newPacketReader(TaskAwareHttpResponsePacket packet) throws InvalidPacketException {
        AbstractHttpDevicePacketReader reader;
        String contentType;
        if (this.overrideResponseContentType != null) {
            contentType = this.overrideResponseContentType;
            if (LOG.isDebugEnabled()) {
                LOG.debug("The content type of the response is overridden to be {}", (Object)contentType);
            }
        } else {
            contentType = packet.getRawContentType();
            if (contentType == null) {
                LOG.error("No Content-Type header in the response, and no override content type set");
                throw new InvalidPacketException("Unable to determine Content-Type");
            }
        }
        switch (contentType = contentType.toLowerCase()) {
            case "application/json": {
                reader = new JsonPacketReader(this.timestampFormat, this.serviceProviderIdPattern, this.factory);
                break;
            }
            case "text/csv": {
                reader = new CsvPacketReader(this.timestampFormat, this.serviceProviderIdPattern, this.csvDelimiterChar, this.csvTitles, this.csvNumberLocale, this.csvMaxLines);
                break;
            }
            default: {
                if (contentType.endsWith("+json")) {
                    reader = new JsonPacketReader(this.timestampFormat, this.serviceProviderIdPattern, this.factory);
                    break;
                }
                LOG.error("Unable to parse responses of type {}", (Object)contentType);
                throw new InvalidPacketException("Unable to parse content type " + contentType);
            }
        }
        reader.load((Packet)packet);
        return reader;
    }
}

