/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.sthbnd.http.factory.endpoint;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RootMappingTree {
    private final Node rootNode = new Node();

    public RootMappingTree(Collection<String> selections) {
        if (selections.isEmpty()) {
            this.rootNode.addChild("");
        } else {
            selections.forEach(x$0 -> this.rootNode.addChild(x$0));
        }
    }

    public Action getAction(List<Object> context) {
        Action toReturn;
        if (context.isEmpty()) {
            toReturn = this.rootNode.isTerminal() ? Action.Select : (this.rootNode.isWildcard() || this.rootNode.hasChildren() ? Action.Search : Action.Ignore);
        } else {
            Node n = this.rootNode;
            for (int i = 0; i < context.size() - 1 && (n = n.getChild(context.get(i).toString())) != null; ++i) {
            }
            toReturn = n == null ? Action.Ignore : (n.isWildcard() ? Action.Select : ((n = n.getChild(context.get(context.size() - 1).toString())) == null ? Action.Ignore : (n.isTerminal() ? Action.Select : Action.Search)));
        }
        return toReturn;
    }

    public String getMappedPath(LinkedList<Object> context) {
        if (context.isEmpty()) {
            return this.rootNode.isTerminal() ? "" : null;
        }
        StringBuilder sb = new StringBuilder();
        Node n = this.rootNode;
        for (int i = 0; i < context.size() - 1; ++i) {
            String s = context.get(i).toString();
            if ((n = n.getChild(s)) == null) {
                return null;
            }
            sb.append(s).append("/");
        }
        if (n.isWildcard()) {
            sb.append("*");
        } else {
            String s = context.get(context.size() - 1).toString();
            if ((n = n.getChild(s)) == null || !n.isTerminal()) {
                return null;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static class Node {
        private final Map<String, Node> children = new HashMap<String, Node>();
        private boolean terminal;
        private boolean wildcard;

        private Node() {
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public Node getChild(String s) {
            return this.children.get(s);
        }

        private void addChild(String s) {
            if (s.isEmpty()) {
                if (this.wildcard || this.hasChildren()) {
                    throw new IllegalArgumentException("A selected path may not have children");
                }
                this.terminal = true;
            } else if (s.equals("*")) {
                if (this.terminal || this.hasChildren()) {
                    throw new IllegalArgumentException("A wildcard path may not be selected or have children");
                }
                this.wildcard = true;
            } else {
                if (this.wildcard || this.terminal) {
                    throw new IllegalArgumentException("A path may not be a child of a selected or wildcard path");
                }
                int idx = s.indexOf(47);
                if (idx < 0) {
                    idx = s.length();
                }
                Node node = this.children.computeIfAbsent(s.substring(0, idx), k -> new Node());
                node.addChild(idx == s.length() ? "" : s.substring(idx + 1));
            }
        }
    }

    public static enum Action {
        Select,
        Ignore,
        Search;

    }
}

