/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.ResourceConfig;
import org.eclipse.sensinact.gateway.generic.ProtocolStackEndpoint;
import org.eclipse.sensinact.gateway.generic.SubscribeTaskWrapper;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskCallBack;
import org.eclipse.sensinact.gateway.generic.TaskImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscribeTaskWrapper
implements SubscribeTaskWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSubscribeTaskWrapper.class);
    protected Task task;
    protected String subscriptionId;
    protected Mediator mediator;
    protected ProtocolStackEndpoint<?> endpoint;

    private AbstractSubscribeTaskWrapper() {
        throw new IllegalArgumentException();
    }

    protected AbstractSubscribeTaskWrapper(Mediator mediator, Task task, ProtocolStackEndpoint<?> endpoint) {
        if (!Task.CommandType.SUBSCRIBE.equals((Object)task.getCommand())) {
            throw new IllegalArgumentException("Subscribe Task expected");
        }
        this.task = task;
        this.mediator = mediator;
        this.endpoint = endpoint;
    }

    @Override
    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        this.endpoint.registerSubsciptionIdentifier(this);
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getTargetId() {
        try {
            return (String)this.targetIdExtractor().execute((Object)this.task);
        }
        catch (Exception e) {
            LOG.error("Error when extracting the subscriber identifier", (Throwable)e);
            return null;
        }
    }

    public String getJSON() {
        return this.task.getJSON();
    }

    @Override
    public Task.RequestType getRequestType() {
        return this.task.getRequestType();
    }

    @Override
    public Task.CommandType getCommand() {
        return this.task.getCommand();
    }

    @Override
    public boolean isDirect() {
        return this.task.isDirect();
    }

    @Override
    public Task.LifecycleStatus getLifecycleStatus() {
        return this.task.getLifecycleStatus();
    }

    @Override
    public String getTaskIdentifier() {
        return this.task.getTaskIdentifier();
    }

    @Override
    public void setTaskIdentifier(String taskIdentifier) {
        this.task.setTaskIdentifier(taskIdentifier);
    }

    @Override
    public ResourceConfig getResourceConfig() {
        return this.task.getResourceConfig();
    }

    @Override
    public Object[] getParameters() {
        return this.task.getParameters();
    }

    @Override
    public String getPath() {
        return this.task.getPath();
    }

    @Override
    public String getProfile() {
        return this.task.getProfile();
    }

    @Override
    public boolean isResultAvailable() {
        return this.task.isResultAvailable();
    }

    @Override
    public void setResult(Object result) {
        try {
            this.setSubscriptionId((String)this.subscriptionIdExtractor().execute(result));
        }
        catch (Exception e) {
            LOG.error("Error when extracting the subscription identifier", (Throwable)e);
        }
        this.task.setResult(result);
    }

    @Override
    public void setResult(Object result, long timestamp) {
        try {
            this.setSubscriptionId((String)this.subscriptionIdExtractor().execute(result));
        }
        catch (Exception e) {
            LOG.error("Error when extracting the subscription identifier", (Throwable)e);
        }
        this.task.setResult(result, timestamp);
    }

    @Override
    public long getTimestamp() {
        return this.task.getTimestamp();
    }

    @Override
    public Object getResult() {
        return this.task.getResult();
    }

    @Override
    public void execute() {
        ((TaskImpl)this.task).setLifecycleStatus(Task.LifecycleStatus.LAUNCHED);
        ((TaskImpl)this.task).launched = System.currentTimeMillis();
        ((TaskImpl)this.task).transmitter.send(this);
    }

    @Override
    public long getTimeout() {
        return this.task.getTimeout();
    }

    @Override
    public void setTimeout(long timeout) {
        this.task.setTimeout(timeout);
    }

    @Override
    public void abort(Object result) {
        this.task.abort(result);
    }

    @Override
    public void registerCallBack(TaskCallBack callback) {
        this.task.registerCallBack(callback);
    }
}

