/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sensinact.gateway.common.bundle.Mediator;
import org.eclipse.sensinact.gateway.core.InvalidServiceProviderException;
import org.eclipse.sensinact.gateway.core.method.Parameter;
import org.eclipse.sensinact.gateway.generic.Connector;
import org.eclipse.sensinact.gateway.generic.ExtModelConfiguration;
import org.eclipse.sensinact.gateway.generic.InvalidProtocolStackException;
import org.eclipse.sensinact.gateway.generic.SubscribeTaskWrapper;
import org.eclipse.sensinact.gateway.generic.SubscriptionHandlerDelegate;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.TaskTranslator;
import org.eclipse.sensinact.gateway.generic.TaskWrapper;
import org.eclipse.sensinact.gateway.generic.UnsubscribeTaskWrapper;
import org.eclipse.sensinact.gateway.generic.packet.InvalidPacketException;
import org.eclipse.sensinact.gateway.generic.packet.Packet;
import org.eclipse.sensinact.gateway.generic.parser.Commands;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProtocolStackEndpoint<P extends Packet>
implements TaskTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(ProtocolStackEndpoint.class);
    protected Connector<P> connector;
    protected Commands commands;
    protected Map<String, String> subscriptions = new HashMap<String, String>();
    protected SubscriptionHandlerDelegate subscriptionHandlerDelegate;

    public void connect(ExtModelConfiguration<P> manager) throws InvalidProtocolStackException {
        this.commands = manager.getCommands();
        this.connector = manager.connect(this);
        if (this.connector != null) {
            for (Map.Entry<String, String> entry : manager.getFixedProviders().entrySet()) {
                try {
                    this.connector.addModelInstance(entry.getValue(), entry.getKey());
                }
                catch (InvalidServiceProviderException e) {
                    throw new InvalidProtocolStackException(e);
                }
            }
        }
    }

    public void setSubscriptionHandlerDelegate(SubscriptionHandlerDelegate subscriptionHandlerDelegate) {
        this.subscriptionHandlerDelegate = subscriptionHandlerDelegate;
    }

    public void setSubsciptionIdentifier(UnsubscribeTaskWrapper task) {
        task.setSubscriptionId(this.subscriptions.get(task.getTargetId()));
    }

    protected Class<? extends UnsubscribeTaskWrapper> getUnsubscribeTaskWrapperType() {
        if (this.subscriptionHandlerDelegate != null) {
            return this.subscriptionHandlerDelegate.getUnsubscribeTaskWrapperType();
        }
        return null;
    }

    public void registerSubsciptionIdentifier(SubscribeTaskWrapper task) {
        this.subscriptions.put(task.getTargetId(), task.getSubscriptionId());
    }

    protected Class<? extends SubscribeTaskWrapper> getSubscribeTaskWrapperType() {
        if (this.subscriptionHandlerDelegate != null) {
            return this.subscriptionHandlerDelegate.getSubscribeTaskWrapperType();
        }
        return null;
    }

    protected <T extends Task> T wrap(Class<T> type, T task) {
        Class<UnsubscribeTaskWrapper> wrapperType;
        if (task == null) {
            return null;
        }
        if (task instanceof TaskWrapper) {
            return task;
        }
        Task _task = null;
        if (task.getCommand().equals((Object)Task.CommandType.SUBSCRIBE)) {
            Class<SubscribeTaskWrapper> wrapperType2 = this.getSubscribeTaskWrapperType();
            if (wrapperType2 != null) {
                try {
                    _task = wrapperType2.getDeclaredConstructor(Mediator.class, type, ProtocolStackEndpoint.class).newInstance(task, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    _task = null;
                }
            }
        } else if (task.getCommand().equals((Object)Task.CommandType.UNSUBSCRIBE) && (wrapperType = this.getUnsubscribeTaskWrapperType()) != null) {
            try {
                _task = wrapperType.getDeclaredConstructor(Mediator.class, type, ProtocolStackEndpoint.class).newInstance(task, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                _task = null;
            }
        }
        if (_task == null) {
            _task = task;
        }
        return (T)_task;
    }

    public void process(P packet) throws InvalidPacketException {
        if (this.connector == null) {
            LOG.debug("No processor connected");
            return;
        }
        this.connector.process(packet);
    }

    public byte[] getCommand(Task.CommandType commandType) {
        if (this.commands == null) {
            return new byte[0];
        }
        return this.commands.getCommand(commandType);
    }

    public static byte[] join(byte[][] arrays, byte[] delimiter) {
        int delimiterLength;
        byte[] joined = new byte[]{};
        int length = 0;
        int n = delimiterLength = delimiter == null ? 0 : delimiter.length;
        for (int index = 0; index < arrays.length; ++index) {
            if (arrays[index] == null || arrays[index].length <= 0) continue;
            if (delimiterLength > 0 && length > 0) {
                joined = Arrays.copyOf(joined, length + delimiterLength);
                System.arraycopy(delimiter, 0, joined, length, delimiterLength);
                length += delimiterLength;
            }
            joined = Arrays.copyOf(joined, length + arrays[index].length);
            System.arraycopy(arrays[index], 0, joined, length, arrays[index].length);
            length += arrays[index].length;
        }
        return joined;
    }

    public static byte[] formatParameter(Object parameter, byte[] delimiter) {
        if (parameter == null) {
            return null;
        }
        byte[] valueBytes = new byte[]{};
        if (String.class.isAssignableFrom(parameter.getClass())) {
            valueBytes = ((String)parameter).getBytes();
        } else if (JSONObject.class.isAssignableFrom(parameter.getClass())) {
            valueBytes = ((JSONObject)parameter).toString().getBytes();
        } else if (JSONArray.class.isAssignableFrom(parameter.getClass())) {
            valueBytes = ((JSONArray)parameter).toString().getBytes();
        } else if (Parameter.class.isAssignableFrom(parameter.getClass())) {
            valueBytes = ProtocolStackEndpoint.formatParameter(((Parameter)parameter).getValue(), delimiter);
        } else if (parameter.getClass().isArray()) {
            for (int j = 0; j < Array.getLength(parameter); ++j) {
                Object param = Array.get(parameter, j);
                byte[] formated = ProtocolStackEndpoint.formatParameter(param, delimiter);
                if (formated == null || formated.length <= 0) continue;
                int length = valueBytes.length;
                if (valueBytes.length > 0 && delimiter != null && delimiter.length > 0) {
                    valueBytes = Arrays.copyOfRange(valueBytes, 0, length + delimiter.length);
                    System.arraycopy(delimiter, 0, valueBytes, length, delimiter.length);
                    length += delimiter.length;
                }
                valueBytes = Arrays.copyOfRange(valueBytes, 0, length + formated.length);
                System.arraycopy(formated, 0, valueBytes, length, formated.length);
            }
        } else {
            valueBytes = Byte.TYPE.equals(parameter.getClass()) || Byte.class.equals(parameter.getClass()) ? new byte[]{(Byte)parameter} : String.valueOf(parameter).getBytes();
        }
        return valueBytes;
    }

    public void stop() {
        if (this.connector != null) {
            this.connector.stop();
        } else {
            LOG.debug("No processor connected");
        }
    }
}

