/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sensinact.gateway.generic.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sensinact.gateway.generic.Task;
import org.eclipse.sensinact.gateway.generic.packet.PayloadResourceFragment;
import org.eclipse.sensinact.gateway.generic.packet.PayloadServiceFragment;
import org.eclipse.sensinact.gateway.generic.packet.TaskIdValuePair;

public class PayloadServiceFragmentImpl
implements PayloadServiceFragment {
    private String name;
    private String taskIdentifier;
    protected String serviceId;
    protected String resourceId;
    protected Task.CommandType command;
    protected List<PayloadResourceFragment> payloadAttributeFragments = new ArrayList<PayloadResourceFragment>();

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public Task.CommandType getCommand() {
        return this.command;
    }

    public void setCommand(Task.CommandType command) {
        this.command = command;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void addPayloadAttributeFragment(PayloadResourceFragment payloadAttributeFragment) {
        if (payloadAttributeFragment != null) {
            this.payloadAttributeFragments.add(payloadAttributeFragment);
        }
    }

    public Iterator<PayloadResourceFragment> iterator() {
        return Collections.unmodifiableList(this.payloadAttributeFragments).iterator();
    }

    private void buildTaskIdentifier(String serviceProviderIdentifier) {
        if (this.command != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(serviceProviderIdentifier);
            buffer.append('#');
            buffer.append(this.getName());
            this.taskIdentifier = buffer.toString();
        }
    }

    @Override
    public List<TaskIdValuePair> AsTaskIdValuePair(String serviceProviderIdentifier) {
        int length;
        this.buildTaskIdentifier(serviceProviderIdentifier);
        ArrayList<TaskIdValuePair> taskIdValuePairs = new ArrayList<TaskIdValuePair>();
        int n = length = this.payloadAttributeFragments == null ? 0 : this.payloadAttributeFragments.size();
        for (int index = 0; index < length; ++index) {
            TaskIdValuePair taskIdValuePair = this.payloadAttributeFragments.get(index).AsTaskIdValuePair(this.taskIdentifier);
            if (taskIdValuePair == null) continue;
            taskIdValuePairs.add(taskIdValuePair);
            break;
        }
        return taskIdValuePairs;
    }

    @Override
    public boolean treated(String taskIdentifier) {
        int length;
        if (taskIdentifier == null) {
            return false;
        }
        int n = length = this.payloadAttributeFragments == null ? 0 : this.payloadAttributeFragments.size();
        for (int index = 0; index < length; ++index) {
            if (!taskIdentifier.equals(this.payloadAttributeFragments.get(index).getTaskIdentifier())) continue;
            this.payloadAttributeFragments.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.payloadAttributeFragments.size();
    }

    public String getName() {
        if (this.name == null) {
            StringBuilder builder = new StringBuilder();
            if (this.command != null) {
                builder.append(this.command.name());
                if (this.serviceId != null) {
                    builder.append('#');
                }
            }
            if (this.serviceId != null) {
                builder.append(this.serviceId);
                if (this.resourceId != null) {
                    builder.append('#');
                }
            }
            if (this.resourceId != null) {
                builder.append(this.resourceId);
            }
            this.name = builder.toString();
        }
        return this.name;
    }
}

